/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core;

import io.yupiik.uship.httpclient.core.DelegatingHttpClient;
import io.yupiik.uship.httpclient.core.ExtendedHttpClientConfiguration;
import io.yupiik.uship.httpclient.core.listener.RequestListener;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ExtendedHttpClient
extends DelegatingHttpClient
implements AutoCloseable {
    private final AtomicLong requestCounter;
    private final List<RequestListener<?>> listeners = new ArrayList();
    private final List<Consumer<ExtendedHttpClient>> onClose = new ArrayList<Consumer<ExtendedHttpClient>>();
    private final boolean isChild;

    public ExtendedHttpClient(ExtendedHttpClientConfiguration clientConfiguration) {
        super(Optional.ofNullable(clientConfiguration.getDelegate()).orElseGet(HttpClient::newHttpClient));
        this.isChild = false;
        this.requestCounter = new AtomicLong();
        if (clientConfiguration.getRequestListeners() != null) {
            this.listeners.addAll(clientConfiguration.getRequestListeners());
        }
    }

    public ExtendedHttpClient(ExtendedHttpClient extendedHttpClient) {
        super(extendedHttpClient.delegate);
        this.isChild = true;
        this.requestCounter = extendedHttpClient.requestCounter;
        this.listeners.addAll(extendedHttpClient.listeners);
    }

    public ExtendedHttpClient onClose(Consumer<ExtendedHttpClient> task) {
        this.onClose.add(task);
        return this;
    }

    public long getRequestCount() {
        return this.requestCounter.get();
    }

    @Override
    public void close() {
        if (this.isChild) {
            return;
        }
        this.onClose.forEach(it -> it.accept(this));
        this.listeners.stream().filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).forEach(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private RequestListener.State<List<Object>> prepare(HttpRequest request) {
        HttpRequest req = request;
        ArrayList states = new ArrayList(this.listeners.size());
        long count = this.requestCounter.incrementAndGet();
        for (RequestListener<?> l : this.listeners) {
            RequestListener.State<?> state = l.before(count, req);
            req = state.request();
            states.add(state.state());
        }
        return new RequestListener.State<List<Object>>(req, states);
    }

    private <T> void after(Iterator<Object> states, HttpRequest request, Throwable err, HttpResponse<T> res) {
        for (RequestListener<?> l : this.listeners) {
            if (!states.hasNext()) break;
            RequestListener looselyTyped = (RequestListener)RequestListener.class.cast(l);
            looselyTyped.after(states.next(), request, err, res);
        }
    }

    public HttpResponse<String> send(HttpRequest request) {
        try {
            return this.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public HttpResponse<Path> getFile(HttpRequest request, Path target) {
        try {
            return this.send(request, HttpResponse.BodyHandlers.ofFile(target));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        RequestListener.State<List<Object>> prepare = this.prepare(request);
        Iterator<Object> state = prepare.state().iterator();
        try {
            HttpResponse<T> res = super.send(prepare.request(), responseBodyHandler);
            this.after(state, request, null, res);
            return res;
        }
        catch (IOException | RuntimeException re) {
            this.after(state, request, re, null);
            throw re;
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        RequestListener.State<List<Object>> prepare = this.prepare(request);
        return super.sendAsync(prepare.request(), responseBodyHandler).whenComplete((ok, ko) -> this.after(((List)prepare.state()).iterator(), request, (Throwable)ko, (HttpResponse)ok));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        RequestListener.State<List<Object>> prepare = this.prepare(request);
        return super.sendAsync(prepare.request(), responseBodyHandler, pushPromiseHandler).whenComplete((ok, ko) -> this.after(((List)prepare.state()).iterator(), request, (Throwable)ko, (HttpResponse)ok));
    }
}

