/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core;

import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class DelegatingHttpClient
extends HttpClient
implements AutoCloseable {
    protected final HttpClient delegate;

    public DelegatingHttpClient(HttpClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.delegate.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.delegate.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.delegate.followRedirects();
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.delegate.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.delegate.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.delegate.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.delegate.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.delegate.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.delegate.executor();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        return this.delegate.send(request, responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return this.delegate.sendAsync(request, responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return this.delegate.sendAsync(request, responseBodyHandler, pushPromiseHandler);
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return this.delegate.newWebSocketBuilder();
    }

    @Override
    public void close() throws Exception {
        if (AutoCloseable.class.isInstance(this.delegate)) {
            ((AutoCloseable)AutoCloseable.class.cast(this.delegate)).close();
        }
    }

    public static class Synchronous
    extends DelegatingHttpClient {
        public Synchronous(HttpClient delegate) {
            super(delegate);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
            try {
                return CompletableFuture.completedFuture(this.send(request, handler));
            }
            catch (IOException | RuntimeException re) {
                CompletableFuture<HttpResponse<T>> future = new CompletableFuture<HttpResponse<T>>();
                future.completeExceptionally(re);
                return future;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ie);
            }
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
            return this.sendAsync(request, handler);
        }
    }
}

