/*
 * Copyright (c) 2021, 2022 - Yupiik SAS - https://www.yupiik.com
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.yupiik.bundlebee.maven.generated.mojo;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import io.yupiik.bundlebee.core.BundleBee;
import io.yupiik.bundlebee.maven.mojo.BaseMojo;

import java.util.Map;
import java.util.stream.Stream;

/**
 * Shows the application version.
 */
@Mojo(name = "version", requiresProject = false, threadSafe = true /* not strictly true but avoids warning inaccurate for builds */)
public class VersionMojo extends BaseMojo {


    /**
     * Custom properties injected in the main, it is often used for placeholders.
     * If the key (tag in pom) starts with `bundlebee-placeholder-import` then the value is resolved as a properties file
     * which is injected in the resulting placeholders (indirect placeholders).
     */
    @Parameter(property = "bundlebee.version.customPlaceholders")
    private Map<String, String> customPlaceholders;

    @Override
    public void doExecute() {
        new BundleBee().launch(Stream.concat(
                        Stream.of(
                                "version"),
                        toArgs(customPlaceholders))
                .toArray(String[]::new));
    }
}
