/*
 * Copyright (c) 2021, 2022 - Yupiik SAS - https://www.yupiik.com
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.yupiik.bundlebee.maven.generated.mojo;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import io.yupiik.bundlebee.core.BundleBee;
import io.yupiik.bundlebee.maven.mojo.BaseMojo;

import java.util.Map;
import java.util.stream.Stream;

/**
 * Creates a new project.
 */
@Mojo(name = "new", requiresProject = true, threadSafe = true /* not strictly true but avoids warning inaccurate for builds */)
public class NewMojo extends BaseMojo {
    /**
     * Bundle artifactId.
     */
    @Parameter(property = "bundlebee.new.artifact", defaultValue = "${project.artifactId}")
    private String artifact;

    /**
     * Where to create the project. If not set it will use the artifact value in current folder.
     */
    @Parameter(property = "bundlebee.new.dir", defaultValue = "${project.build.outputDirectory}")
    private String dir;

    /**
     * If `true` the execution runs even if dir already exists.
     */
    @Parameter(property = "bundlebee.new.force", defaultValue = "true")
    private boolean force;

    /**
     * Bundle groupId.
     */
    @Parameter(property = "bundlebee.new.group", defaultValue = "${project.groupId}")
    private String group;

    /**
     * If `true` no pom.xml is generated.
     */
    @Parameter(property = "bundlebee.new.skipPom", defaultValue = "true")
    private boolean skipPom;

    /**
     * By default a sample alveolus with a config map is generated, if `false` it will be skipped.
     */
    @Parameter(property = "bundlebee.new.skipSamples", defaultValue = "true")
    private boolean skipSamples;

    /**
     * Bundle version.
     */
    @Parameter(property = "bundlebee.new.version", defaultValue = "${project.version}")
    private String version;

    /**
     * Custom properties injected in the main, it is often used for placeholders.
     * If the key (tag in pom) starts with `bundlebee-placeholder-import` then the value is resolved as a properties file
     * which is injected in the resulting placeholders (indirect placeholders).
     */
    @Parameter(property = "bundlebee.new.customPlaceholders")
    private Map<String, String> customPlaceholders;

    @Override
    public void doExecute() {
        new BundleBee().launch(Stream.concat(
                        Stream.of(
                                "new",
                                "--artifact",
                                String.valueOf(artifact),
                                "--dir",
                                String.valueOf(dir),
                                "--force",
                                String.valueOf(force),
                                "--group",
                                String.valueOf(group),
                                "--skipPom",
                                String.valueOf(skipPom),
                                "--skipSamples",
                                String.valueOf(skipSamples),
                                "--version",
                                String.valueOf(version)),
                        toArgs(customPlaceholders))
                .toArray(String[]::new));
    }
}
