/*
 * Copyright (c) 2021, 2022 - Yupiik SAS - https://www.yupiik.com
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.yupiik.bundlebee.maven.generated.mojo;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import io.yupiik.bundlebee.core.BundleBee;
import io.yupiik.bundlebee.maven.mojo.BaseMojo;

import java.util.Map;
import java.util.stream.Stream;

/**
 * Lists all found alveoli
 */
@Mojo(name = "list-alveoli", requiresProject = false, threadSafe = true /* not strictly true but avoids warning inaccurate for builds */)
public class ListAlveoliMojo extends BaseMojo {
    /**
     * Root dependency to download to get the manifest. If set to `auto` it is assumed to be present in current classpath.
     */
    @Parameter(property = "bundlebee.list-alveoli.from", defaultValue = "auto")
    private String from;

    /**
     * Manifest to load to start to find the alveolus. This optional setting mainly enables to use dependencies easily. Ignored if set to `skip`.
     */
    @Parameter(property = "bundlebee.list-alveoli.manifest", defaultValue = "skip")
    private String manifest;

    /**
     * `logger` means the standard bundlebee logging output stream else it is considered as a file path. Note that if you end the filename with `.json` it will be formatted as json else just readable text.
     */
    @Parameter(property = "bundlebee.list-alveoli.output", defaultValue = "logger")
    private String output;

    /**
     * Custom properties injected in the main, it is often used for placeholders.
     * If the key (tag in pom) starts with `bundlebee-placeholder-import` then the value is resolved as a properties file
     * which is injected in the resulting placeholders (indirect placeholders).
     */
    @Parameter(property = "bundlebee.list-alveoli.customPlaceholders")
    private Map<String, String> customPlaceholders;

    /**
     * Just an alias for the built-in manifest property to ease the pom configuration for all commands.
     */
    @Parameter(property = "bundlebee.manifest", defaultValue = "skip")
    private String defaultManifest;

    @Override
    public void doExecute() {
        new BundleBee().launch(Stream.concat(
                        Stream.of(
                                "list-alveoli",
                                "--from",
                                String.valueOf(from),
                                "--manifest",
                                String.valueOf("skip".equals(manifest) ? defaultManifest : manifest),
                                "--output",
                                String.valueOf(output)),
                        toArgs(customPlaceholders))
                .toArray(String[]::new));
    }
}
