/*
 * Copyright (c) 2021, 2022 - Yupiik SAS - https://www.yupiik.com
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.yupiik.bundlebee.maven.generated.mojo;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import io.yupiik.bundlebee.core.BundleBee;
import io.yupiik.bundlebee.maven.mojo.BaseMojo;

import java.util.Map;
import java.util.stream.Stream;

/**
 * Build a project.
 */
@Mojo(name = "build", requiresProject = true, threadSafe = true /* not strictly true but avoids warning inaccurate for builds */)
public class BuildMojo extends BaseMojo {
    /**
     * Bundle artifactId.
     */
    @Parameter(property = "bundlebee.build.artifact", defaultValue = "${project.artifactId}")
    private String artifact;

    /**
     * Project to build.
     */
    @Parameter(property = "bundlebee.build.builddir", defaultValue = "target")
    private String builddir;

    /**
     * If `true` it will be added to your local maven repository.
     */
    @Parameter(property = "bundlebee.build.deployInLocalRepository", defaultValue = "true")
    private boolean deployInLocalRepository;

    /**
     * Project to build.
     */
    @Parameter(property = "bundlebee.build.dir", defaultValue = ".")
    private String dir;

    /**
     * Bundle groupId.
     */
    @Parameter(property = "bundlebee.build.group", defaultValue = "${project.groupId}")
    private String group;

    /**
     * Bundle version.
     */
    @Parameter(property = "bundlebee.build.version", defaultValue = "${project.version}")
    private String version;

    /**
     * Custom properties injected in the main, it is often used for placeholders.
     * If the key (tag in pom) starts with `bundlebee-placeholder-import` then the value is resolved as a properties file
     * which is injected in the resulting placeholders (indirect placeholders).
     */
    @Parameter(property = "bundlebee.build.customPlaceholders")
    private Map<String, String> customPlaceholders;

    @Override
    public void doExecute() {
        new BundleBee().launch(Stream.concat(
                        Stream.of(
                                "build",
                                "--artifact",
                                String.valueOf(artifact),
                                "--builddir",
                                String.valueOf(builddir),
                                "--deployInLocalRepository",
                                String.valueOf(deployInLocalRepository),
                                "--dir",
                                String.valueOf(dir),
                                "--group",
                                String.valueOf(group),
                                "--version",
                                String.valueOf(version)),
                        toArgs(customPlaceholders))
                .toArray(String[]::new));
    }
}
