/*
 * Copyright (c) 2021, 2022 - Yupiik SAS - https://www.yupiik.com
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.yupiik.bundlebee.maven.generated.mojo;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import io.yupiik.bundlebee.core.BundleBee;
import io.yupiik.bundlebee.maven.mojo.BaseMojo;

import java.util.Map;
import java.util.stream.Stream;

/**
 * Adds a service to the alveoli available in the defined folder. It is a skaffolding command.
 */
@Mojo(name = "add-alveolus", requiresProject = true, threadSafe = true /* not strictly true but avoids warning inaccurate for builds */)
public class AddAlveolusMojo extends BaseMojo {
    /**
     * Alveolus name.
     */
    @Parameter(property = "bundlebee.add-alveolus.alveolus", defaultValue = "${project.groupId}:${project.artifactId}:${project.version}")
    private String alveolus;

    /**
     * Deployment image.
     */
    @Parameter(property = "bundlebee.add-alveolus.image", defaultValue = "<unset>")
    private String image;

    /**
     * Manifest to add the aveolus inside.
     */
    @Parameter(property = "bundlebee.add-alveolus.manifest", defaultValue = "${project.build.outputDirectory}/bundlebee/manifest.json")
    private String manifest;

    /**
     * If `false`, generated files already existing will be skipped.
     */
    @Parameter(property = "bundlebee.add-alveolus.overwrite", defaultValue = "false")
    private boolean overwrite;

    /**
     * Alveolus/template type. `web` will create a `ConfigMap`, `Deployment` and `Service`.
     */
    @Parameter(property = "bundlebee.add-alveolus.type", defaultValue = "web")
    private String type;

    /**
     * Custom properties injected in the main, it is often used for placeholders.
     * If the key (tag in pom) starts with `bundlebee-placeholder-import` then the value is resolved as a properties file
     * which is injected in the resulting placeholders (indirect placeholders).
     */
    @Parameter(property = "bundlebee.add-alveolus.customPlaceholders")
    private Map<String, String> customPlaceholders;

    /**
     * Just an alias for the built-in manifest property to ease the pom configuration for all commands.
     */
    @Parameter(property = "bundlebee.manifest", defaultValue = "skip")
    private String defaultManifest;

    @Override
    public void doExecute() {
        new BundleBee().launch(Stream.concat(
                        Stream.of(
                                "add-alveolus",
                                "--alveolus",
                                String.valueOf(alveolus),
                                "--image",
                                String.valueOf(image),
                                "--manifest",
                                String.valueOf("skip".equals(manifest) ? defaultManifest : manifest),
                                "--overwrite",
                                String.valueOf(overwrite),
                                "--type",
                                String.valueOf(type)),
                        toArgs(customPlaceholders))
                .toArray(String[]::new));
    }
}
