/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.spark;

import io.warp10.spark.Warp10Spark;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SparkInputFormat
extends InputFormat<Object, Object> {
    private InputFormat wrappedInputFormat = null;
    private static final String SPARK_INPUTFORMAT_CLASS = "spark.inputformat.class";

    public RecordReader<Object, Object> createRecordReader(InputSplit split, TaskAttemptContext attempt) throws IOException, InterruptedException {
        return this.getWrappedInputFormat(attempt.getConfiguration()).createRecordReader(split, attempt);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        return this.getWrappedInputFormat(job.getConfiguration()).getSplits(job);
    }

    private InputFormat getWrappedInputFormat(Configuration conf) throws IOException {
        if (null == this.wrappedInputFormat) {
            try {
                String cls = conf.get(SPARK_INPUTFORMAT_CLASS);
                Class<?> innerClass = Class.forName(cls);
                this.wrappedInputFormat = (InputFormat)innerClass.newInstance();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
        return this.wrappedInputFormat;
    }

    static {
        Warp10Spark.init();
    }
}

