/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.spark;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class SPARKSCHEMA
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SPARKSCHEMA(String name) {
        super(name);
    }

    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        Target target = Target.valueOf(String.valueOf(top).toUpperCase());
        top = stack.pop();
        stack.push((Object)SPARKSCHEMA.schema(target, top, true));
        return stack;
    }

    private static final String schema(Target target, Object o) throws WarpScriptException {
        return SPARKSCHEMA.schema(target, o, false);
    }

    public static final String schema(Target target, Object o, boolean outer) throws WarpScriptException {
        if (o instanceof Row) {
            Row row = (Row)o;
            StructType schema = row.schema();
            StringBuilder sb = new StringBuilder();
            switch (target) {
                case JAVA: {
                    sb.append("DataTypes.createStructType(new SructField[] {");
                    break;
                }
                case SCALA: {
                    sb.append("StructType(List(");
                    break;
                }
                case PYTHON: {
                    sb.append("StructType([");
                    break;
                }
                case DDL: {
                    if (outer) break;
                    sb.append("STRUCT<");
                }
            }
            sb.append("\n");
            block66: for (int i = 0; i < row.size(); ++i) {
                if (0 != i) {
                    sb.append(",\n");
                }
                String name = "c" + i;
                if (null != schema) {
                    name = schema.apply(i).name();
                }
                switch (target) {
                    case JAVA: {
                        sb.append("DataTypes.createStructField(\"" + name.replaceAll("\"", "\\\"") + "\",");
                        sb.append(SPARKSCHEMA.schema(target, row.get(i)));
                        sb.append(",true)");
                        continue block66;
                    }
                    case SCALA: {
                        sb.append("StructField(\"" + name.replaceAll("\"", "\\\"") + "\",");
                        sb.append(SPARKSCHEMA.schema(target, row.get(i)));
                        sb.append(",true)");
                        continue block66;
                    }
                    case PYTHON: {
                        sb.append("StructField(\"" + name.replaceAll("\"", "\\\"") + "\",");
                        sb.append(SPARKSCHEMA.schema(target, row.get(i)));
                        sb.append(",True)");
                        continue block66;
                    }
                    case DDL: {
                        if (outer) {
                            sb.append("`" + name.replaceAll("`", "``") + "` ");
                        } else {
                            sb.append("'" + name.replaceAll("'", "\\'") + "': ");
                        }
                        sb.append(SPARKSCHEMA.schema(target, row.get(i)));
                    }
                }
            }
            switch (target) {
                case JAVA: {
                    sb.append("\n");
                    sb.append("})");
                    break;
                }
                case SCALA: {
                    sb.append("\n");
                    sb.append("))");
                    break;
                }
                case PYTHON: {
                    sb.append("\n");
                    sb.append("])");
                    break;
                }
                case DDL: {
                    if (outer) break;
                    sb.append(">");
                }
            }
            return sb.toString();
        }
        if (o instanceof List) {
            StringBuilder sb = new StringBuilder();
            switch (target) {
                case JAVA: {
                    sb.append("DataTypes.createArrayType(");
                    sb.append(SPARKSCHEMA.schema(target, ((List)o).get(0)));
                    sb.append(",true)");
                    break;
                }
                case SCALA: {
                    sb.append("ArrayType(");
                    sb.append(SPARKSCHEMA.schema(target, ((List)o).get(0)));
                    sb.append(",true)");
                    break;
                }
                case PYTHON: {
                    sb.append("ArrayType(");
                    sb.append(SPARKSCHEMA.schema(target, ((List)o).get(0)));
                    sb.append(",True)");
                    break;
                }
                case DDL: {
                    sb.append("ARRAY<");
                    sb.append(SPARKSCHEMA.schema(target, ((List)o).get(0)));
                    sb.append(">");
                }
            }
            return sb.toString();
        }
        if (o instanceof Map) {
            StringBuilder sb = new StringBuilder();
            switch (target) {
                case JAVA: {
                    sb.append("DataTypes.createMapType(");
                    Map.Entry entry = ((Map)o).entrySet().iterator().next();
                    sb.append(SPARKSCHEMA.schema(target, entry.getKey()));
                    sb.append(",");
                    sb.append(SPARKSCHEMA.schema(target, entry.getValue()));
                    sb.append(",true)");
                    break;
                }
                case SCALA: {
                    sb.append("MapType(");
                    Map.Entry entry = ((Map)o).entrySet().iterator().next();
                    sb.append(SPARKSCHEMA.schema(target, entry.getKey()));
                    sb.append(",");
                    sb.append(SPARKSCHEMA.schema(target, entry.getValue()));
                    sb.append(",true)");
                    break;
                }
                case PYTHON: {
                    sb.append("MapType(");
                    Map.Entry entry = ((Map)o).entrySet().iterator().next();
                    sb.append(SPARKSCHEMA.schema(target, entry.getKey()));
                    sb.append(",");
                    sb.append(SPARKSCHEMA.schema(target, entry.getValue()));
                    sb.append(",True)");
                    break;
                }
                case DDL: {
                    sb.append("MAP<");
                    Map.Entry entry = ((Map)o).entrySet().iterator().next();
                    sb.append(SPARKSCHEMA.schema(target, entry.getKey()));
                    sb.append(",");
                    sb.append(SPARKSCHEMA.schema(target, entry.getValue()));
                    sb.append(">");
                }
            }
            return sb.toString();
        }
        if (o instanceof String) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.StringType";
                }
                case SCALA: {
                    return "StringType";
                }
                case PYTHON: {
                    return "StringType()";
                }
                case DDL: {
                    return "STRING";
                }
            }
        } else if (o instanceof Double) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.DoubleType";
                }
                case SCALA: {
                    return "DoubleType";
                }
                case PYTHON: {
                    return "DoubleType()";
                }
                case DDL: {
                    return "DOUBLE";
                }
            }
        } else if (o instanceof Long) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.LongType";
                }
                case SCALA: {
                    return "LongType";
                }
                case PYTHON: {
                    return "LongType()";
                }
                case DDL: {
                    return "LONG";
                }
            }
        } else if (o instanceof Boolean) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.BooleanType";
                }
                case SCALA: {
                    return "BooleanType";
                }
                case PYTHON: {
                    return "BooleanType()";
                }
                case DDL: {
                    return "BOOLEAN";
                }
            }
        } else if (o instanceof byte[]) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.BinaryType";
                }
                case SCALA: {
                    return "BinaryType";
                }
                case PYTHON: {
                    return "BinaryType()";
                }
                case DDL: {
                    return "BINARY";
                }
            }
        } else if (null == o) {
            switch (target) {
                case JAVA: {
                    return "DataTypes.NullType";
                }
                case SCALA: {
                    return "NullType";
                }
                case PYTHON: {
                    return "NullType()";
                }
                case DDL: {
                    return "OBJECT";
                }
            }
        } else {
            throw new WarpScriptException("Unsupported type " + o.getClass());
        }
        return null;
    }

    private static enum Target {
        JAVA,
        SCALA,
        PYTHON,
        DDL;

    }
}

