/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.spark.common;

import io.warp10.crypto.SipHashInline;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptExecutor;
import io.warp10.spark.Warp10Spark;
import io.warp10.spark.common.SparkUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkFiles;

public abstract class WarpScriptAbstractFunction
implements Serializable {
    public static final String WARPSCRIPT_FILE_VARIABLE = "warpscript.file";
    public static final String WARPSCRIPT_ID_VARIABLE = "warpscript.id";
    private WarpScriptExecutor.StackSemantics semantics;
    protected WarpScriptExecutor executor = null;
    public static final String DEFAULT_TIME_UNITS_PER_MS = "us";
    private static final int EXECUTOR_MAX_KEY_SIZE = 1024;
    private static final int EXECUTOR_CACHE_SIZE = 128;
    protected static long[] SIPKEY_SCRIPT;
    protected static long[] SIPKEY_UUID;
    private static final Map<Object, WarpScriptExecutor> executors;

    public WarpScriptAbstractFunction() {
        this.semantics = WarpScriptExecutor.StackSemantics.PERTHREAD;
    }

    public WarpScriptAbstractFunction(String ... args) throws WarpScriptException {
        if (0 == args.length) {
            throw new IllegalArgumentException("At least one parameter is required: WarpScript\u2122 code");
        }
        if (1 == args.length) {
            this.semantics = WarpScriptExecutor.StackSemantics.PERTHREAD;
            this.setCode(args[0]);
        } else {
            this.setCode(args[0]);
            this.semantics = WarpScriptExecutor.StackSemantics.valueOf((String)args[1]);
            if (args.length > 2) {
                for (int i = 1; i < args.length; ++i) {
                    String[] tokens = args[i].split("=");
                    System.setProperty(tokens[0], tokens[1]);
                }
            } else {
                System.setProperty("warp.timeunits", DEFAULT_TIME_UNITS_PER_MS);
            }
        }
    }

    public void setCode(String code) throws WarpScriptException {
        this.init(code);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.semantics.toString());
        out.writeObject(this.executor);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.semantics = WarpScriptExecutor.StackSemantics.valueOf((String)in.readUTF());
        this.executor = (WarpScriptExecutor)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String code) throws WarpScriptException {
        Object key = code;
        if (code.length() > 1024) {
            byte[] keyHash = code.getBytes(StandardCharsets.UTF_8);
            key = SipHashInline.hash24((long)SIPKEY_SCRIPT[0], (long)SIPKEY_SCRIPT[1], (byte[])keyHash, (int)0, (int)keyHash.length);
        }
        WarpScriptExecutor executor = executors.get(key);
        try {
            if (null == executor) {
                byte[] keyHash = code.getBytes(StandardCharsets.UTF_8);
                long hash = SipHashInline.hash24((long)SIPKEY_SCRIPT[0], (long)SIPKEY_SCRIPT[1], (byte[])keyHash, (int)0, (int)keyHash.length);
                Map<Object, WarpScriptExecutor> map = executors;
                synchronized (map) {
                    if (code.startsWith("@") || code.startsWith("%")) {
                        String originalfilePath = code.substring(1);
                        String filename = Paths.get(originalfilePath, new String[0]).getFileName().toString();
                        String filePath = SparkFiles.get((String)filename);
                        String mc2FileContent = "'" + filePath + "' '" + WARPSCRIPT_FILE_VARIABLE + "' STORE " + SparkUtils.parseScript(filename);
                        executor = new WarpScriptExecutor(this.semantics, mc2FileContent, null, null, code.startsWith("@"));
                    } else {
                        String mc2Content = "'" + String.valueOf(hash) + "' '" + WARPSCRIPT_ID_VARIABLE + "' STORE " + code;
                        executor = new WarpScriptExecutor(this.semantics, mc2Content, null, null);
                    }
                    executors.put(key, executor);
                }
            }
            this.executor = executor;
        }
        catch (IOException ioe) {
            throw new WarpScriptException((Throwable)ioe);
        }
    }

    public WarpScriptExecutor getExecutor() {
        return this.executor;
    }

    static {
        Warp10Spark.init();
        SIPKEY_SCRIPT = new long[]{-1074115777491809362L, -9164287957047038398L};
        SIPKEY_UUID = new long[]{-1080031158605624146L, 1303691782022928929L};
        executors = new LinkedHashMap<Object, WarpScriptExecutor>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, WarpScriptExecutor> eldest) {
                return this.size() > 128;
            }
        };
    }
}

