/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.spark.common;

import com.google.common.base.Charsets;
import io.warp10.script.WarpScriptException;
import io.warp10.spark.Warp10Spark;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Row;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;

public class SparkUtils {
    public static Object fromSpark(Object o) {
        if (null == o || o instanceof NullWritable) {
            return null;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof byte[]) {
            return o;
        }
        if (o instanceof BytesWritable) {
            return ((BytesWritable)o).getBytes();
        }
        if (o instanceof BigInteger || o instanceof Long || o instanceof Integer || o instanceof Byte) {
            return ((Number)o).longValue();
        }
        if (o instanceof BigDecimal || o instanceof Double || o instanceof Float) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Product) {
            Product prod = (Product)o;
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = prod.productIterator();
            while (iter.hasNext()) {
                list.add(SparkUtils.fromSpark(iter.next()));
            }
            return list;
        }
        if (o instanceof List) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object elt : (List)o) {
                l.add(SparkUtils.fromSpark(elt));
            }
            return l;
        }
        if (o instanceof Row) {
            ArrayList<Object> l = new ArrayList<Object>(((Row)o).size());
            Row row = (Row)o;
            for (int i = 0; i < row.size(); ++i) {
                l.add(SparkUtils.fromSpark(row.get(i)));
            }
            return l;
        }
        if (o instanceof Iterator || o instanceof Iterable) {
            final Iterator siter = o instanceof Iterator ? (Iterator)o : ((Iterable)o).iterator();
            return new java.util.Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return siter.hasNext();
                }

                @Override
                public Object next() {
                    return siter.next();
                }
            };
        }
        return o;
    }

    public static Object toSpark(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof byte[]) {
            return o;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o instanceof List) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object elt : (List)o) {
                l.add(SparkUtils.toSpark(elt));
            }
            return l;
        }
        if (o instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                map.put(SparkUtils.toSpark(entry.getKey()), SparkUtils.toSpark(entry.getValue()));
            }
            return map;
        }
        return o;
    }

    public static String parseScript(String warpscriptFile) throws IOException, WarpScriptException {
        StringBuffer scriptSB = new StringBuffer();
        InputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            File f = new File(SparkFiles.get((String)warpscriptFile));
            fis = !f.exists() ? SparkUtils.class.getClassLoader().getResourceAsStream(warpscriptFile) : new FileInputStream(f);
            if (null == fis) {
                throw new IOException("WarpScript file '" + warpscriptFile + "' could not be found.");
            }
            br = new BufferedReader(new InputStreamReader(fis, Charsets.UTF_8));
            while (null != (line = br.readLine())) {
                scriptSB.append(line).append("\n");
            }
        }
        catch (IOException ioe) {
            throw new IOException("WarpScript file could not be loaded", ioe);
        }
        finally {
            if (null == br) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            if (null == fis) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return scriptSB.toString();
    }

    public static void saveAsNewAPIHadoopFile(JavaRDD rdd, String path, String kc, String vc, String ofc, Map<String, String> cf) throws Exception {
        Warp10Spark.init();
        JavaPairRDD prdd = JavaPairRDD.fromJavaRDD((JavaRDD)rdd);
        Class<?> keyClass = Class.forName(kc);
        Class<?> valueClass = Class.forName(vc);
        Class<?> outputFormatClass = Class.forName(ofc);
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : cf.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        prdd.saveAsNewAPIHadoopFile(path, keyClass, valueClass, outputFormatClass, conf);
    }
}

