/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.spark;

import io.warp10.WarpConfig;
import io.warp10.script.WarpScriptLib;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.LogManager;
import org.apache.spark.SparkFiles;

public class Warp10Spark {
    private static final String DISABLE_LOGGING = "disable.logging";

    public static void init() {
        try {
            if (null != System.getProperty("warp10.config")) {
                InputStream in = Warp10Spark.class.getClassLoader().getResourceAsStream(System.getProperty("warp10.config"));
                if (null == in) {
                    try {
                        in = new FileInputStream(SparkFiles.get((String)System.getProperty("warp10.config")));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (null == in) {
                    in = new FileInputStream(System.getProperty("warp10.config"));
                }
                WarpConfig.safeSetProperties((Reader)new InputStreamReader(in));
            } else if (null != System.getenv("WARP10_CONFIG")) {
                InputStream in = Warp10Spark.class.getClassLoader().getResourceAsStream(System.getenv("WARP10_CONFIG"));
                if (null == in) {
                    try {
                        in = new FileInputStream(SparkFiles.get((String)System.getenv("WARP10_CONFIG")));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (null == in) {
                    in = new FileInputStream(System.getenv("WARP10_CONFIG"));
                }
                WarpConfig.safeSetProperties((Reader)new InputStreamReader(in));
            } else {
                WarpConfig.safeSetProperties((String[])new String[]{null});
            }
            WarpScriptLib.registerExtensions();
            if ("true".equals(System.getProperty(DISABLE_LOGGING))) {
                LogManager.getLogManager().reset();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

