/*
 * Decompiled with CFR 0.152.
 */
package minium.script.rhinojs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.IOException;
import minium.internal.Module;
import minium.script.js.JsBrowserFactory;
import minium.script.rhinojs.RhinoEngine;
import minium.script.rhinojs.RhinoWebModules;
import minium.web.CoreWebElements;
import minium.web.actions.WebDriverBrowser;
import minium.web.config.WebDriverFactory;
import minium.web.config.WebDriverProperties;
import minium.web.internal.WebModule;
import minium.web.internal.WebModules;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.openqa.selenium.WebDriver;

public class RhinoBrowserFactory
implements JsBrowserFactory {
    private final ObjectMapper mapper = new ObjectMapper();
    private final RhinoEngine engine;
    private final WebDriverFactory webDriverFactory;

    public RhinoBrowserFactory(RhinoEngine engine) {
        this(engine, new WebDriverFactory(null));
    }

    public RhinoBrowserFactory(RhinoEngine engine, WebDriverFactory webDriverFactory) {
        this.engine = engine;
        this.webDriverFactory = webDriverFactory;
    }

    public WebDriverBrowser<?> create(Object obj) {
        try {
            WebDriverProperties webDriverProperties;
            if (obj instanceof Scriptable && "String".equals(((Scriptable)obj).getClassName())) {
                obj = obj.toString();
            }
            if (obj instanceof String) {
                webDriverProperties = new WebDriverProperties();
                webDriverProperties.getDesiredCapabilities().put("browserName", obj);
            } else if (obj instanceof Scriptable) {
                final Scriptable scriptable = (Scriptable)obj;
                RhinoEngine rhinoEngine = this.engine;
                rhinoEngine.getClass();
                String json = this.engine.runWithContext(new RhinoEngine.RhinoCallable<String, RuntimeException>(rhinoEngine){

                    @Override
                    protected String doCall(Context cx, Scriptable scope) throws RuntimeException {
                        return (String)cx.evaluateString(scriptable, "JSON.stringify(this)", "<expression>", 1, null);
                    }
                });
                webDriverProperties = (WebDriverProperties)this.mapper.readValue(json, WebDriverProperties.class);
            } else {
                throw new IllegalArgumentException("Only strings or maps are accepted");
            }
            WebDriver wd = this.webDriverFactory.create(webDriverProperties);
            WebModule webModule = WebModules.combine((WebModule[])new WebModule[]{WebModules.defaultModule((WebDriver)wd), WebModules.debugModule(), RhinoWebModules.rhinoModule()});
            return new WebDriverBrowser(wd, CoreWebElements.DefaultWebElements.class, (Module)webModule);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

