/*
 * Decompiled with CFR 0.152.
 */
package minium.project.generator.utils;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;

public final class Utils {
    private Utils() {
    }

    public static String toClassName(String name) {
        String result = Utils.splitUpperCaseIntoSpace(name);
        result = Utils.splitUnderscoreIntoSpace(result);
        result = Utils.splitDotsIntoSpace(result);
        result = Utils.replaceSpacesWithLowerHyphen(result);
        result = Utils.toCamelCase(result);
        return result;
    }

    public static String splitDotsIntoSpace(String str) {
        return str.replaceAll("(.)(\\.+)", "$1 ");
    }

    public static String splitUpperCaseIntoSpace(String str) {
        Object[] r = str.split("(?=\\p{Upper})");
        return Joiner.on((String)"-").join(r);
    }

    public static String splitUnderscoreIntoSpace(String str) {
        return str.replaceAll("(.)(\\_+)", "$1 ");
    }

    public static String replaceSpecialCharsWithSpaces(String name) {
        return name.replaceAll("[^\\w\\s]", " ");
    }

    public static String replaceSpacesWithLowerHyphen(String name) {
        return name.replaceAll("\\s+", "-");
    }

    public static String toCamelCase(String name) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name);
    }
}

