/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import minium.cucumber.rest.SimpleGlue;
import minium.cucumber.rest.dto.HookDefinitionDTO;
import minium.cucumber.rest.dto.StepDefinitionDTO;

public class GlueDTO
implements Serializable {
    private static final long serialVersionUID = -1207719130996258182L;
    private UUID uuid;
    private List<StepDefinitionDTO> stepDefinitions = new ArrayList<StepDefinitionDTO>();
    private List<HookDefinitionDTO> beforeHooks = new ArrayList<HookDefinitionDTO>();
    private List<HookDefinitionDTO> afterHooks = new ArrayList<HookDefinitionDTO>();

    public GlueDTO() {
    }

    public GlueDTO(SimpleGlue glue) {
        this.uuid = glue.getUuid();
        for (Map.Entry<Long, HookDefinition> entry : glue.getBeforeHookDefinitions().entrySet()) {
            this.beforeHooks.add(new HookDefinitionDTO(this.uuid, entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Long, HookDefinition> entry : glue.getAfterHookDefinitions().entrySet()) {
            this.afterHooks.add(new HookDefinitionDTO(this.uuid, entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Long, HookDefinition> entry : glue.getStepDefinitions().entrySet()) {
            this.stepDefinitions.add(new StepDefinitionDTO(this.uuid, entry.getKey(), (StepDefinition)entry.getValue()));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public List<StepDefinitionDTO> getStepDefinitions() {
        return this.stepDefinitions;
    }

    public void setStepDefinitions(List<StepDefinitionDTO> stepDefinitions) {
        this.stepDefinitions = stepDefinitions;
    }

    public List<HookDefinitionDTO> getBeforeHooks() {
        return this.beforeHooks;
    }

    public void setBeforeHooks(List<HookDefinitionDTO> beforeHookDefinitions) {
        this.beforeHooks = beforeHookDefinitions;
    }

    public List<HookDefinitionDTO> getAfterHooks() {
        return this.afterHooks;
    }

    public void setAfterHooks(List<HookDefinitionDTO> afterHookDefinitions) {
        this.afterHooks = afterHookDefinitions;
    }
}

