/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import minium.web.internal.WebElementFunctions;
import minium.web.internal.expression.BaseExpression;
import minium.web.internal.expression.VariableGenerator;
import org.openqa.selenium.WebElement;

public class NativeWebElementsExpression
extends BaseExpression {
    private final List<? extends WebElement> nativeWebElements;

    public NativeWebElementsExpression(WebElement ... nativeWebElements) {
        this(Lists.newArrayList((Object[])nativeWebElements));
    }

    public NativeWebElementsExpression(List<? extends WebElement> nativeWebElements) {
        this.nativeWebElements = nativeWebElements;
    }

    @Override
    public String getJavascript(VariableGenerator varGenerator) {
        return String.format("$(%s)", varGenerator.generate());
    }

    @Override
    public Object[] getArgs() {
        ImmutableList unwrappedNativedWebElements = FluentIterable.from(this.nativeWebElements).transform(WebElementFunctions.unwrap()).toList();
        return new Object[]{unwrappedNativedWebElements};
    }
}

