/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class ServletWebSocketHandlerRegistry
implements WebSocketHandlerRegistry {
    private final List<ServletWebSocketHandlerRegistration> registrations = new ArrayList<ServletWebSocketHandlerRegistration>();
    private TaskScheduler sockJsTaskScheduler;
    private int order = 1;
    private UrlPathHelper urlPathHelper;

    public ServletWebSocketHandlerRegistry(ThreadPoolTaskScheduler sockJsTaskScheduler) {
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    @Override
    public WebSocketHandlerRegistration addHandler(WebSocketHandler webSocketHandler, String ... paths) {
        ServletWebSocketHandlerRegistration registration = new ServletWebSocketHandlerRegistration(this.sockJsTaskScheduler);
        registration.addHandler(webSocketHandler, paths);
        this.registrations.add(registration);
        return registration;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public AbstractHandlerMapping getHandlerMapping() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        for (ServletWebSocketHandlerRegistration registration : this.registrations) {
            MultiValueMap mappings = (MultiValueMap)registration.getMappings();
            for (HttpRequestHandler httpHandler : mappings.keySet()) {
                for (String pattern : (List)mappings.get((Object)httpHandler)) {
                    urlMap.put(pattern, httpHandler);
                }
            }
        }
        WebSocketHandlerMapping hm = new WebSocketHandlerMapping();
        hm.setUrlMap(urlMap);
        hm.setOrder(this.order);
        if (this.urlPathHelper != null) {
            hm.setUrlPathHelper(this.urlPathHelper);
        }
        return hm;
    }
}

