/*
 * Decompiled with CFR 0.152.
 */
package platypus;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;

public interface Mixin {
    public boolean is(Class<?> var1);

    public boolean is(TypeToken<?> var1);

    public <A> A as(Class<A> var1);

    public <A> A as(TypeToken<A> var1);

    public static class Impl
    implements Mixin {
        protected Object that = this;

        @Override
        public boolean is(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return clazz.isInstance(this.that);
        }

        @Override
        public boolean is(TypeToken<?> type) {
            Preconditions.checkNotNull(type);
            return this.is(type.getRawType());
        }

        @Override
        public <A> A as(Class<A> clazz) {
            Preconditions.checkNotNull(clazz);
            Preconditions.checkState((boolean)clazz.isInstance(this.that), (String)"that is not an instance of %s", (Object[])new Object[]{clazz});
            return (A)this.that;
        }

        @Override
        public <A> A as(TypeToken<A> type) {
            Preconditions.checkNotNull(type);
            Class clazz = type.getRawType();
            Preconditions.checkState((boolean)clazz.isInstance(this.that), (String)"that is not an instance of %s", (Object[])new Object[]{clazz});
            return (A)this.that;
        }

        public final void setProxy(Object proxy) {
            Preconditions.checkState((this.that == this ? 1 : 0) != 0, (Object)"Mixin proxy instance can only be set once!");
            this.that = Preconditions.checkNotNull((Object)proxy);
        }
    }
}

