/*
 * Decompiled with CFR 0.152.
 */
package minium.project.generator.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import minium.project.generator.web.rest.dto.ProjectDTO;
import org.apache.commons.io.FileUtils;

public abstract class ProjectTemplate {
    protected ProjectDTO project;
    protected String path;

    public ProjectTemplate(ProjectDTO project) {
        this.project = project;
        this.path = this.getBasePathName();
    }

    public final void buildProject() throws IOException {
        this.buildStructure();
        this.buildFiles();
    }

    public abstract void buildStructure() throws IOException;

    public abstract void buildFiles() throws IOException;

    protected String createParentDir(String path) throws IOException {
        File f = new File(path);
        FileUtils.forceMkdir((File)f);
        return f.getPath();
    }

    protected void copyStructure(String destPath, String template) throws IOException {
        File templateDir = new File(template);
        File destDir = new File(destPath);
        FileUtils.copyDirectory((File)templateDir, (File)destDir);
    }

    protected String getBasePathName() {
        File f = new File(this.project.getDirectory(), this.project.getName());
        return f.getPath();
    }

    protected void copyResource(String resourcePath, File destPath, String fileName) throws IOException {
        try (InputStream myResource = this.getClass().getResourceAsStream(resourcePath);){
            File myResourceAsFile = new File(destPath, fileName);
            FileUtils.copyInputStreamToFile((InputStream)myResource, (File)myResourceAsFile);
        }
    }
}

