/*
 * Decompiled with CFR 0.152.
 */
package minium.project.generator.template;

import com.google.common.collect.Maps;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import minium.project.generator.template.MavenProjectTemplate;
import minium.project.generator.utils.Utils;
import minium.project.generator.web.rest.dto.ProjectDTO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringProject
extends MavenProjectTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringProject.class);

    public MonitoringProject(ProjectDTO project, String miniumVersion, String springVersion) {
        super(project, "monitoring", miniumVersion, springVersion);
    }

    @Override
    public void buildFiles() throws IOException {
        this.createExecutorClass();
        this.createAssemblyFile();
        super.buildFiles();
    }

    private void createExecutorClass() throws IOException {
        File f = new File(this.path + "/src/main/java");
        FileUtils.forceMkdir((File)f);
        File newFile = new File(f, "ExecutorTest.java");
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        try {
            Template template = cfg.getTemplate("monitoring-project/ExecutorTest.ftl");
            HashMap data = Maps.newHashMap();
            data.put("className", this.project.getGroupId() + "." + Utils.toClassName(this.project.getArtifactId()) + "IT");
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(newFile));){
                template.process((Object)data, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error occurred when generating {}", (Object)newFile, (Object)e);
        }
    }

    private void createAssemblyFile() throws IOException {
        File f = new File(this.path + "/src/main/assembly");
        FileUtils.forceMkdir((File)f);
        this.copyResource("/monitoring-project/assembly.xml", f, "assembly.xml");
    }

    @Override
    protected void buildCucumberFiles() throws IOException {
        File f = new File(this.path + "/src/test/resources/steps");
        this.copyResource("/monitoring-project/after.js", f, "after.js");
        f = new File(this.path + "/src/test/resources/modules");
        this.copyResource("/monitoring-project/performance.js", f, "performance.js");
        super.buildCucumberFiles();
    }
}

