/*
 * Decompiled with CFR 0.152.
 */
package minium.project.generator.template;

import com.google.common.collect.Maps;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import minium.project.generator.template.ProjectTemplate;
import minium.project.generator.utils.Utils;
import minium.project.generator.web.rest.dto.ProjectDTO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectTemplate
extends ProjectTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectTemplate.class);
    private static final String APPLICATION_YML = "application.yml";
    private static final String POM_XML = "pom.xml";
    protected static final String MONITORING = "monitoring";
    protected static final String WEB_APP_TESTING = "cucumber";
    private final String templateName;
    private final String miniumVersion;
    private final String springVersion;

    public MavenProjectTemplate(ProjectDTO project, String templateName, String miniumVersion, String springVersion) {
        super(project);
        this.templateName = templateName;
        this.miniumVersion = miniumVersion;
        this.springVersion = springVersion;
    }

    @Override
    public void buildStructure() throws IOException {
        this.createParentDir(this.path);
        this.createStructure(this.path);
    }

    @Override
    public void buildFiles() throws IOException {
        this.buildPom(this.path);
        String mainPath = this.path + "/src/test/java";
        String groupId = this.project.getGroupId().replaceAll("\\.", "\\/");
        File f = new File(mainPath, groupId);
        FileUtils.forceMkdir((File)f);
        this.buildCucumberFiles();
        this.buildTestClass(f);
    }

    private void createStructure(String destPath) throws IOException {
        File file = new File(destPath, "src/test/java");
        FileUtils.forceMkdir((File)file);
        file = new File(destPath, "src/test/resources");
        FileUtils.forceMkdir((File)file);
        ArrayList<String> resourcesFolders = new ArrayList<String>();
        resourcesFolders.add("config");
        resourcesFolders.add("features");
        resourcesFolders.add("modules");
        resourcesFolders.add("steps");
        for (String folder : resourcesFolders) {
            File newFile = new File(file, folder);
            FileUtils.forceMkdir((File)newFile);
        }
        File fileModules = new File(file, "config");
        this.copyResource("/" + this.templateName + "-project/" + APPLICATION_YML, fileModules, APPLICATION_YML);
    }

    private void buildPom(String path) {
        File newFile = new File(path, POM_XML);
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        try {
            Template template = cfg.getTemplate(this.templateName + "-project/pom.ftl");
            HashMap data = Maps.newHashMap();
            data.put("groupId", this.project.getGroupId());
            data.put("artifactId", this.project.getArtifactId());
            data.put("version", this.project.getVersion());
            data.put("miniumVersion", this.miniumVersion != null ? this.miniumVersion : "1.1.0-SNAPSHOT");
            data.put("springVersion", this.springVersion);
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(newFile));){
                template.process((Object)data, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error occurred when generating {}", (Object)newFile, (Object)e);
        }
    }

    private void buildTestClass(File f) {
        String className = Utils.toClassName(this.project.getArtifactId()) + "IT";
        String fileName = className + ".java";
        File newFile = new File(f, fileName);
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        try {
            Template template = cfg.getTemplate(this.templateName + "-project/test-class.ftl");
            HashMap data = Maps.newHashMap();
            data.put("groupId", this.project.getGroupId());
            data.put("className", className);
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(newFile));){
                template.process((Object)data, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error occurred when generating {}", (Object)newFile, (Object)e);
        }
    }

    protected void buildCucumberFiles() throws IOException {
        String resourcesPath = this.path + "/src/test/resources/";
        File f = new File(resourcesPath, "features");
        File fileModules = new File(f, "");
        this.copyResource("/" + this.templateName + "-project/Feature.feature", fileModules, this.project.getFeatureFile() + ".feature");
        f = new File(resourcesPath, "steps");
        fileModules = new File(f, "");
        this.copyResource("/" + this.templateName + "-project/steps.js", fileModules, this.project.getStepFile() + ".js");
        this.copyResource("/" + this.templateName + "-project/world.js", fileModules, "world.js");
    }
}

