/*
 * Decompiled with CFR 0.152.
 */
package minium.web.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import minium.web.utils.dto.MonitoringReportDTO;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformanceUtils.class);

    private PerformanceUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getPerformanceJson(WebDriver webdriver, String url) {
        MonitoringReportDTO monitoringReportDTO = new MonitoringReportDTO(url);
        MonitoringReportDTO.Performance performance = (MonitoringReportDTO.Performance)PerformanceUtils.getValue(webdriver, "return JSON.stringify(window.performance)", MonitoringReportDTO.Performance.class);
        MonitoringReportDTO.Stats stats = (MonitoringReportDTO.Stats)PerformanceUtils.getValue(webdriver, "var numberOfRequests = 0; var pageSize = 0; performance.getEntriesByType('resource').forEach(function(elem) { numberOfRequests++; pageSize += elem.transferSize }); return JSON.stringify({\"pageSize\": pageSize, \"numberOfRequests\": numberOfRequests })", MonitoringReportDTO.Stats.class);
        monitoringReportDTO.setData(performance);
        monitoringReportDTO.setStats(stats);
        monitoringReportDTO.setStatusCode(PerformanceUtils.processStatusCode(webdriver, url));
        monitoringReportDTO.setJsErrors(webdriver.manage().logs().get("browser").filter(Level.SEVERE));
        String result = "";
        try {
            result = new ObjectMapper().writeValueAsString((Object)monitoringReportDTO);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Error converting the Object MonitoringReportDTO to String", (Throwable)e);
        }
        return result;
    }

    private static Object getValue(WebDriver webdriver, String expression, Class<?> clazz) {
        try {
            String result = (String)((JavascriptExecutor)webdriver).executeScript(expression, new Object[0]);
            return new ObjectMapper().readValue(result, clazz);
        }
        catch (IOException e) {
            LOGGER.warn("Error processing the performance data for the class {}", (Object)clazz.getName(), (Object)e);
            return null;
        }
    }

    private static int processStatusCode(WebDriver webdriver, String url) {
        int statusCode = -1;
        Pattern methodPattern = Pattern.compile("Network.responseReceived");
        Pattern urlPattern = Pattern.compile("\"url\":\"" + url + "/?\"");
        Pattern statusPattern = Pattern.compile("\"status\":(\\d+)");
        try {
            LogEntries logEntries = webdriver.manage().logs().get("performance");
            for (LogEntry logEntry : logEntries) {
                Matcher statusMatcher;
                Matcher methodMatcher = methodPattern.matcher(logEntry.getMessage());
                Matcher urlMatcher = urlPattern.matcher(logEntry.getMessage());
                if (!methodMatcher.find() || !urlMatcher.find() || !(statusMatcher = statusPattern.matcher(logEntry.getMessage())).find()) continue;
                statusCode = Integer.parseInt(statusMatcher.group(1));
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error processing the performance logs extracted from the browser", (Throwable)e);
        }
        if (statusCode == -1) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            String httpProxy = System.getenv("MINIUM_MONITORING_PERFORMANCE_HTTPPROXY");
            if (httpProxy != null && !httpProxy.isEmpty()) {
                String[] proxyConfigs = httpProxy.split(":");
                int proxyPort = Integer.parseInt(proxyConfigs[1]);
                builder.setProxy(new HttpHost(proxyConfigs[0], proxyPort));
            }
            CloseableHttpClient client = builder.build();
            try {
                HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
                statusCode = response.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                LOGGER.warn("Error at the http response to extract from the http response code", (Throwable)e);
            }
        }
        return statusCode;
    }
}

