/*
 * Decompiled with CFR 0.152.
 */
package minium.web.actions;

import java.util.Set;
import minium.internal.ElementsFactory;
import minium.internal.Module;
import minium.internal.Modules;
import minium.web.WebElements;
import minium.web.actions.Browser;
import minium.web.actions.WebConfiguration;
import minium.web.internal.WebElementsFactory;
import minium.web.internal.WebModule;
import minium.web.internal.WebModules;
import minium.web.internal.actions.InternalBrowser;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowser<T extends WebElements>
implements Browser<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverBrowser.class);
    private final InternalBrowser<T> browser;

    public WebDriverBrowser(WebDriver webDriver, Class<T> intf) {
        this(webDriver, intf, null);
    }

    public WebDriverBrowser(WebDriver webDriver, Class<T> intf, Module module) {
        WebModule combinedModules = module == null ? WebModules.defaultModule(webDriver) : Modules.combine((Module[])new Module[]{WebModules.baseModule(webDriver), module});
        LOGGER.debug("Creating a WebDriverBrowser for modules: {}", (Object)combinedModules);
        WebElementsFactory.Builder builder = new WebElementsFactory.Builder();
        combinedModules.configure(builder);
        ElementsFactory factory = builder.build();
        Set providedInterfaces = factory.getProvidedInterfaces();
        LOGGER.trace("Provided interfaces: {}", (Object)providedInterfaces);
        this.browser = new InternalBrowser<ElementsFactory>(factory);
    }

    @Override
    public T root() {
        return this.browser.root();
    }

    @Override
    public T $(String selector) {
        return this.browser.$(selector);
    }

    @Override
    public T $(WebElements ... elems) {
        return this.browser.$(elems);
    }

    @Override
    public void get(String url) {
        this.browser.get(url);
    }

    @Override
    public String getCurrentUrl() {
        return this.browser.getCurrentUrl();
    }

    @Override
    public String getPerformance() {
        return this.browser.getPerformance();
    }

    @Override
    public String getTitle() {
        return this.browser.getTitle();
    }

    @Override
    public void close() {
        this.browser.close();
    }

    @Override
    public void quit() {
        this.browser.quit();
    }

    @Override
    public Browser.Navigation navigate() {
        return this.browser.navigate();
    }

    @Override
    public WebConfiguration configure() {
        return this.browser.configure();
    }

    @Override
    public Browser.Screenshot screenshot() {
        return this.browser.screenshot();
    }

    public String toString() {
        return this.browser.toString();
    }
}

