/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest;

import com.google.common.base.Preconditions;
import cucumber.api.Scenario;
import cucumber.api.SnippetType;
import cucumber.runtime.Backend;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import minium.cucumber.rest.ResourceNotFoundException;
import minium.cucumber.rest.ScenarioAdapter;
import minium.cucumber.rest.SimpleGlue;
import minium.cucumber.rest.dto.ExecutionResult;
import minium.cucumber.rest.dto.GlueDTO;
import minium.cucumber.rest.dto.HookExecutionResult;
import minium.cucumber.rest.dto.ScenarioDTO;
import minium.cucumber.rest.dto.StepDTO;
import minium.cucumber.rest.dto.StepDefinitionInvocation;
import minium.cucumber.rest.dto.StepExecutionResult;
import minium.cucumber.rest.dto.StepMatchDTO;
import minium.cucumber.rest.dto.TagDTO;
import minium.cucumber.rest.dto.WorldDTO;

public class BackendContext {
    private final String backendName;
    private final Backend backend;
    private final Map<UUID, SimpleGlue> glues = new HashMap<UUID, SimpleGlue>();
    final Map<UUID, WorldDTO> worlds = new HashMap<UUID, WorldDTO>();

    public BackendContext(String backendName, Backend backend) {
        this.backendName = backendName;
        this.backend = backend;
    }

    public List<GlueDTO> getGlues() {
        ArrayList<GlueDTO> glueDtos = new ArrayList<GlueDTO>();
        for (SimpleGlue glueProxy : this.glues.values()) {
            glueDtos.add(new GlueDTO(glueProxy));
        }
        return glueDtos;
    }

    public GlueDTO createGlue(String ... paths) {
        SimpleGlue glue = new SimpleGlue();
        this.backend.loadGlue((Glue)glue, Arrays.asList(paths));
        this.glues.put(glue.getUuid(), glue);
        return new GlueDTO(glue);
    }

    public void deleteGlue(UUID uuid) {
        SimpleGlue remoteGlue = this.glues.remove(uuid);
        if (remoteGlue == null) {
            throw new ResourceNotFoundException(String.format("Glue %s not found", uuid));
        }
    }

    public WorldDTO createWorld() {
        WorldDTO world = new WorldDTO(UUID.randomUUID(), this.backendName);
        this.backend.buildWorld();
        this.worlds.put(world.getUuid(), world);
        return world;
    }

    public void deleteWorld(UUID uuid) {
        Preconditions.checkState((boolean)this.worlds.containsKey(uuid), (String)"No world exists with UUID %s", (Object)uuid);
        this.worlds.remove(uuid);
        this.backend.disposeWorld();
    }

    public HookExecutionResult execute(UUID uuid, long id, ScenarioDTO scenarioDto) throws Throwable {
        SimpleGlue glue = this.glues.get(uuid);
        ScenarioAdapter scenarioAdapter = new ScenarioAdapter(scenarioDto);
        HookDefinition hookDefinition = glue.hookDefinition(id);
        try {
            hookDefinition.execute((Scenario)scenarioAdapter);
        }
        catch (Exception e) {
            return new HookExecutionResult(scenarioDto, e);
        }
        return new HookExecutionResult(scenarioDto);
    }

    public boolean matches(UUID uuid, long id, Collection<TagDTO> tags) {
        SimpleGlue glue = this.glues.get(uuid);
        HookDefinition hookDefinition = glue.hookDefinition(id);
        return hookDefinition.matches(this.convertTags(tags));
    }

    public ExecutionResult execute(UUID uuid, long id, StepDefinitionInvocation stepDefinitionInvocation) throws Throwable {
        SimpleGlue glue = this.glues.get(uuid);
        StepDefinition stepDefinition = glue.stepDefinition(id);
        LocalizedXStreams xStreams = new LocalizedXStreams(Thread.currentThread().getContextClassLoader());
        try {
            String isoCode = stepDefinitionInvocation.getIsoCode();
            I18n i18n = new I18n(isoCode);
            stepDefinition.execute(i18n, stepDefinitionInvocation.getArgs(xStreams.get(i18n.getLocale()), stepDefinition));
        }
        catch (Exception e) {
            return new StepExecutionResult(e);
        }
        return new StepExecutionResult();
    }

    public StepMatchDTO matchedArguments(UUID uuid, long id, StepDTO stepProxy) throws Throwable {
        SimpleGlue glue = this.glues.get(uuid);
        StepDefinition stepDefinition = glue.stepDefinition(id);
        List matchedArguments = stepDefinition.matchedArguments(stepProxy.toStep());
        return new StepMatchDTO(matchedArguments);
    }

    public String getSnippet(StepDTO serializableStep, SnippetType type) {
        return this.backend.getSnippet(serializableStep.toStep(), type.getFunctionNameGenerator());
    }

    public Collection<Tag> convertTags(Collection<TagDTO> tags) {
        if (tags == null) {
            return null;
        }
        ArrayList<Tag> gherkinTags = new ArrayList<Tag>();
        for (TagDTO tag : tags) {
            gherkinTags.add(tag.toTag());
        }
        return gherkinTags;
    }
}

