/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.report.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import minium.cucumber.report.domain.Comment;
import minium.cucumber.report.domain.Element;
import minium.cucumber.report.domain.Status;
import minium.cucumber.report.domain.Tag;
import minium.cucumber.report.domain.Views;

public class Feature {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private List<Comment> comments = Lists.newArrayList();
    @JsonView(value={Views.Public.class})
    private String id;
    @JsonView(value={Views.Public.class})
    private String name;
    @JsonView(value={Views.Public.class})
    private String uri;
    @JsonView(value={Views.Public.class})
    private String description;
    @JsonView(value={Views.Public.class})
    private String keyword;
    @JsonView(value={Views.Full.class})
    private List<Element> elements = Lists.newArrayList();
    @JsonView(value={Views.Public.class})
    private List<Tag> tags = Lists.newArrayList();
    @JsonView(value={Views.Public.class})
    private String jsonFile = "";
    @JsonView(value={Views.Public.class})
    private Integer line;
    @JsonView(value={Views.Public.class})
    private Status status;

    public String getId() {
        return this.id;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getJsonFile() {
        return this.jsonFile;
    }

    public void setJsonFile(String json) {
        this.jsonFile = json;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public String getUri() {
        return this.uri;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Integer getLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfScenarios() {
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (Element element : this.elements) {
            if (element.getKeyword().equals("Background") || element.getType().equals("scenario_outline")) continue;
            elementList.add(element);
        }
        return elementList.size();
    }

    public Status getStatus() {
        for (Element elem : this.elements) {
            if (elem.getStatus() == Status.PASSED || elem.getType().equals("scenario_outline")) continue;
            return Status.FAILED;
        }
        return Status.PASSED;
    }
}

