/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.config;

import com.google.common.collect.Lists;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import minium.cucumber.config.CucumberProperties;
import minium.cucumber.rest.RemoteBackend;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
public class CucumberConfiguration {
    @Bean
    @ConfigurationProperties(prefix="minium.cucumber", ignoreUnknownFields=false)
    public CucumberProperties cucumberProperties() {
        return new CucumberProperties();
    }

    @Bean
    @Autowired
    public List<RemoteBackend> remoteBackends(CucumberProperties cucumberProperties) {
        ArrayList backends = Lists.newArrayList();
        for (CucumberProperties.RemoteBackendProperties remoteBackendProperties : cucumberProperties.getRemoteBackends()) {
            backends.add(remoteBackendProperties.createRemoteBackend());
        }
        return backends;
    }

    @Bean
    public ResourceLoader resourceLoader() {
        return new MultiLoader(Thread.currentThread().getContextClassLoader());
    }
}

