/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.data.reader;

import minium.cucumber.data.reader.CSVDataReader;
import minium.cucumber.data.reader.DataReader;
import minium.cucumber.data.reader.ExcelDataReader;
import org.apache.commons.io.FilenameUtils;

public class DataReaderFactory {
    public static DataReader create(String fileName) throws InstantiationException, IllegalAccessException {
        Format reader = DataReaderFactory.getFormat(fileName);
        return reader.getReaderClass().newInstance();
    }

    private static Format getFormat(String fileName) {
        String ext = FilenameUtils.getExtension((String)fileName).toUpperCase();
        return Format.valueOf(ext);
    }

    public static enum Format {
        CSV(CSVDataReader.class),
        XLS(ExcelDataReader.class),
        XLSX(ExcelDataReader.class);

        private Class<? extends DataReader> clazz;

        private Format(Class<? extends DataReader> clazz) {
            this.clazz = clazz;
        }

        public Class<? extends DataReader> getReaderClass() {
            return this.clazz;
        }
    }
}

