/*
 * Decompiled with CFR 0.152.
 */
package minium.developer.fs.web.method.support;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import minium.developer.fs.web.method.support.BaseURL;
import minium.internal.Throwables;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class BaseURLHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        try {
            HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
            String url = BaseURLHandlerMethodArgumentResolver.buildFullRequestUrl(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath(), null);
            if (methodParameter.getParameterType() == String.class) {
                return url;
            }
            if (methodParameter.getParameterType() == URL.class) {
                return new URL(url);
            }
            if (methodParameter.getParameterType() == URI.class) {
                return new URI(url);
            }
            throw new IllegalArgumentException(String.format("Class %s is not supported", methodParameter.getParameterType()));
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        BaseURL baseURL = (BaseURL)methodParameter.getParameterAnnotation(BaseURL.class);
        return baseURL != null;
    }

    protected static String buildFullRequestUrl(String scheme, String serverName, int serverPort, String requestURI, String queryString) {
        scheme = scheme.toLowerCase();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if ("http".equals(scheme)) {
            if (serverPort != 80) {
                url.append(":").append(serverPort);
            }
        } else if ("https".equals(scheme) && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(requestURI);
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }
}

