/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.ZipResource;
import org.apache.ant.compress.util.Messages;
import org.apache.ant.compress.util.ZipStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;

public class ZipScanner
extends CommonsCompressArchiveScanner {
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$FileProvider;

    public ZipScanner() {
        this(false, null);
    }

    public ZipScanner(boolean skipUnreadable, Project project) {
        super(new ZipStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new ZipResource(archive, encoding, (ZipArchiveEntry)entry);
            }
        }, skipUnreadable, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        FileProvider fp = (FileProvider)src.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ZipScanner.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider);
        if (fp == null) {
            super.fillMapsFromArchive(src, encoding, fileEntries, matchFileEntries, dirEntries, matchDirEntries);
            return;
        }
        File srcFile = fp.getFile();
        ZipArchiveEntry entry = null;
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(srcFile, encoding);
            }
            catch (ZipException ex) {
                throw new BuildException("Problem reading " + srcFile, (Throwable)ex);
            }
            catch (IOException ex) {
                throw new BuildException("Problem opening " + srcFile, (Throwable)ex);
            }
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                entry = (ZipArchiveEntry)e.nextElement();
                if (this.getSkipUnreadableEntries() && !zf.canReadEntryData(entry)) {
                    this.log(Messages.skippedIsUnreadable((ArchiveEntry)entry));
                    continue;
                }
                ZipResource r = new ZipResource(srcFile, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = ZipScanner.trimSeparator((String)name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

