/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.regex.Pattern;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.LocationAwareValueMatcher;
import org.skyscreamer.jsonassert.ValueMatcher;
import org.skyscreamer.jsonassert.ValueMatcherException;

public final class Customization {
    private final Pattern path;
    private final ValueMatcher<Object> comparator;

    public Customization(String path, ValueMatcher<Object> comparator) {
        assert (path != null);
        assert (comparator != null);
        this.path = Pattern.compile(this.buildPattern(path));
        this.comparator = comparator;
    }

    private String buildPattern(String path) {
        return this.buildPatternLevel1(path);
    }

    private String buildPatternLevel1(String path) {
        String regex = "\\*\\*\\.";
        String replacement = "(?:.+\\.)?";
        StringBuilder sb = new StringBuilder();
        String[] parts = path.split(regex);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append(this.buildPatternLevel2(part));
            if (i >= parts.length - 1) continue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    private String buildPatternLevel2(String s) {
        if (s.isEmpty()) {
            return "";
        }
        String regex = "\\*\\*";
        String replacement = ".+";
        StringBuilder sb = new StringBuilder();
        String[] parts = s.split(regex);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append(this.buildPatternLevel3(part));
            if (i >= parts.length - 1) continue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    private String buildPatternLevel3(String s) {
        if (s.isEmpty()) {
            return "";
        }
        String regex = "\\*";
        String replacement = "[^\\.]+";
        StringBuilder sb = new StringBuilder();
        String[] parts = s.split(regex);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append(Pattern.quote(part));
            if (i >= parts.length - 1) continue;
            sb.append(replacement);
        }
        return sb.toString();
    }

    public static Customization customization(String path, ValueMatcher<Object> comparator) {
        return new Customization(path, comparator);
    }

    public boolean appliesToPath(String path) {
        return this.path.matcher(path).matches();
    }

    @Deprecated
    public boolean matches(Object actual, Object expected) {
        return this.comparator.equal(actual, expected);
    }

    public boolean matches(String prefix, Object actual, Object expected, JSONCompareResult result) throws ValueMatcherException {
        if (this.comparator instanceof LocationAwareValueMatcher) {
            return ((LocationAwareValueMatcher)this.comparator).equal(prefix, actual, expected, result);
        }
        return this.comparator.equal(actual, expected);
    }
}

