/*
 * Decompiled with CFR 0.152.
 */
package platypus;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import platypus.MixinClass;
import platypus.internal.MixinClassImpl;

public class MixinClasses {
    public static <T> Builder<T> builder(Class<T> intf) {
        return new Builder<T>(intf);
    }

    public static <T> MixinClass<T> create(Class<T> intf, Class<?> ... others) {
        return MixinClasses.create(intf, Arrays.asList(others));
    }

    public static <T> MixinClass<T> create(Class<T> intf, Collection<Class<?>> others) {
        return new MixinClassImpl(intf, others);
    }

    public static class Builder<T> {
        private Class<T> intf;
        private Set<Class<?>> others = Sets.newLinkedHashSet();

        public Builder(Class<T> intf) {
            this.intf = intf;
        }

        public Builder<T> addInterfaces(Class<?> ... others) {
            return this.addInterfaces(Arrays.asList(others));
        }

        public Builder<T> addInterfaces(Collection<Class<?>> others) {
            this.others.addAll(others);
            return this;
        }

        public MixinClass<T> build() {
            return MixinClasses.create(this.intf, this.others);
        }
    }
}

