/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config.services;

import java.io.File;
import java.util.Map;
import minium.web.config.services.DriverServiceProperties;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverServiceProperties
extends DriverServiceProperties {
    private Integer port;
    private File driverExecutable;
    private Map<String, String> environment;
    private File logFile;
    private Boolean verbose;
    private Boolean silent;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public File getDriverExecutable() {
        return this.driverExecutable;
    }

    public void setDriverExecutable(File exe) {
        this.driverExecutable = exe;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public Boolean getSilent() {
        return this.silent;
    }

    public void setSilent(Boolean silent) {
        this.silent = silent;
    }

    @Override
    protected DriverService createDriverService() {
        ChromeDriverService.Builder builder = new ChromeDriverService.Builder();
        if (this.port != null) {
            builder.usingPort(this.port.intValue());
        }
        if (this.driverExecutable != null) {
            builder.usingDriverExecutable(this.driverExecutable);
        }
        if (this.environment != null) {
            builder.withEnvironment(this.environment);
        }
        if (this.logFile != null) {
            builder.withLogFile(this.logFile);
        }
        if (this.verbose != null) {
            builder.withVerbose(this.verbose.booleanValue());
        }
        if (this.silent != null) {
            builder.withSilent(this.silent.booleanValue());
        }
        return builder.build();
    }
}

