/*
 * Decompiled with CFR 0.152.
 */
package platypus.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Classes {
    public static Set<Class<?>> getInterfacesClosure(Class<?> cls) {
        LinkedHashSet closure = Sets.newLinkedHashSet();
        closure.add(cls);
        closure.addAll(Classes.getAllInterfaces(cls));
        return ImmutableSet.copyOf((Collection)closure);
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = Sets.newLinkedHashSet();
        Classes.getAllInterfaces(cls, interfacesFound);
        return ImmutableSet.copyOf((Collection)interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, Collection<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                interfacesFound.add(interfaces[i]);
                Classes.getAllInterfaces(interfaces[i], interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }
}

