/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.StepContainer;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import gherkin.util.FixJava;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CucumberTagStatement
extends StepContainer {
    private final TagStatement gherkinModel;
    private final String visualName;

    CucumberTagStatement(CucumberFeature cucumberFeature, TagStatement gherkinModel) {
        super(cucumberFeature, (BasicStatement)gherkinModel);
        this.gherkinModel = gherkinModel;
        this.visualName = gherkinModel.getKeyword() + ": " + gherkinModel.getName();
    }

    CucumberTagStatement(CucumberFeature cucumberFeature, TagStatement gherkinModel, Row example) {
        super(cucumberFeature, (BasicStatement)gherkinModel);
        this.gherkinModel = gherkinModel;
        this.visualName = "| " + FixJava.join((List)example.getCells(), (String)" | ") + " |";
    }

    protected Set<Tag> tagsAndInheritedTags() {
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.addAll(this.cucumberFeature.getGherkinFeature().getTags());
        tags.addAll(this.gherkinModel.getTags());
        return tags;
    }

    public String getVisualName() {
        return this.visualName;
    }

    public TagStatement getGherkinModel() {
        return this.gherkinModel;
    }

    public abstract void run(Formatter var1, Reporter var2, Runtime var3);
}

