/*
 * Decompiled with CFR 0.152.
 */
package minium.automator;

import minium.automator.config.AutomatorConfiguration;
import minium.automator.config.AutomatorProperties;
import org.springframework.boot.Banner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutomatorConfiguration.class})
public class Application {
    public static void main(String[] args) {
        AutomatorProperties automatorProperties = AutomatorConfiguration.readAutomationProperties(args);
        if (automatorProperties == null) {
            return;
        }
        int exitCode = 0;
        ConfigurableApplicationContext context = null;
        try {
            context = new SpringApplicationBuilder(new Object[]{Application.class}).bannerMode(Banner.Mode.CONSOLE).web(false).build().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 1;
        }
        if (context != null) {
            SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{new SimpleExitCodeGenerator(exitCode)});
        }
    }

    private static final class SimpleExitCodeGenerator
    implements ExitCodeGenerator {
        private final int exitCode;

        public SimpleExitCodeGenerator(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

