/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.apache.tomcat.util.digester.CallParamRule;
import org.apache.tomcat.util.digester.DocumentProperties;
import org.apache.tomcat.util.digester.FactoryCreateRule;
import org.apache.tomcat.util.digester.ObjectCreateRule;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.digester.Rules;
import org.apache.tomcat.util.digester.RulesBase;
import org.apache.tomcat.util.digester.SetNextRule;
import org.apache.tomcat.util.digester.SetPropertiesRule;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PermissionCheck;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

public class Digester
extends DefaultHandler2 {
    protected static IntrospectionUtils.PropertySource propertySource;
    private static boolean propertySourceSet;
    protected static final StringManager sm;
    protected IntrospectionUtils.PropertySource[] source = new IntrospectionUtils.PropertySource[]{new SystemPropertySource()};
    protected StringBuilder bodyText = new StringBuilder();
    protected ArrayStack<StringBuilder> bodyTexts = new ArrayStack();
    protected ArrayStack<List<Rule>> matches = new ArrayStack(10);
    protected ClassLoader classLoader = null;
    protected boolean configured = false;
    protected EntityResolver entityResolver;
    protected HashMap<String, String> entityValidator = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected SAXParserFactory factory = null;
    protected Locator locator = null;
    protected String match = "";
    protected boolean namespaceAware = false;
    protected HashMap<String, ArrayStack<String>> namespaces = new HashMap();
    protected ArrayStack<Object> params = new ArrayStack();
    protected SAXParser parser = null;
    protected String publicId = null;
    protected XMLReader reader = null;
    protected Object root = null;
    protected Rules rules = null;
    protected ArrayStack<Object> stack = new ArrayStack();
    protected boolean useContextClassLoader = false;
    protected boolean validating = false;
    protected boolean rulesValidation = false;
    protected Map<Class<?>, List<String>> fakeAttributes = null;
    protected Log log = LogFactory.getLog(Digester.class);
    protected Log saxLog = LogFactory.getLog("org.apache.tomcat.util.digester.Digester.sax");

    public static void setPropertySource(IntrospectionUtils.PropertySource propertySource) {
        if (!propertySourceSet) {
            Digester.propertySource = propertySource;
            propertySourceSet = true;
        }
    }

    public Digester() {
        propertySourceSet = true;
        if (propertySource != null) {
            this.source = new IntrospectionUtils.PropertySource[]{propertySource, this.source[0]};
        }
    }

    public static void replaceSystemProperties() {
        Log log = LogFactory.getLog(Digester.class);
        if (propertySource != null) {
            IntrospectionUtils.PropertySource[] propertySources = new IntrospectionUtils.PropertySource[]{propertySource};
            Properties properties = System.getProperties();
            Set<String> names = properties.stringPropertyNames();
            for (String name : names) {
                String value = System.getProperty(name);
                if (value == null) continue;
                try {
                    String newValue = IntrospectionUtils.replaceProperties(value, null, propertySources);
                    if (value.equals(newValue)) continue;
                    System.setProperty(name, newValue);
                }
                catch (Exception e) {
                    log.warn(sm.getString("digester.failedToUpdateSystemProperty", name, value), e);
                }
            }
        }
    }

    public String findNamespaceURI(String prefix) {
        ArrayStack<String> stack = this.namespaces.get(prefix);
        if (stack == null) {
            return null;
        }
        try {
            return stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public String getCurrentElementName() {
        String elementName = this.match;
        int lastSlash = elementName.lastIndexOf(47);
        if (lastSlash >= 0) {
            elementName = elementName.substring(lastSlash + 1);
        }
        return elementName;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SAXParserFactory getFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(this.namespaceAware);
            if (this.namespaceAware) {
                this.factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            this.factory.setValidating(this.validating);
            if (this.validating) {
                this.factory.setFeature("http://xml.org/sax/features/validation", true);
                this.factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
        }
        return this.factory;
    }

    public void setFeature(String feature, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(feature, value);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public Log getSAXLogger() {
        return this.saxLog;
    }

    public void setSAXLogger(Log saxLog) {
        this.saxLog = saxLog;
    }

    public String getMatch() {
        return this.match;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    @Deprecated
    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    @Deprecated
    public void setRuleNamespaceURI(String ruleNamespaceURI) {
        this.getRules().setNamespaceURI(ruleNamespaceURI);
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            this.parser = this.getFactory().newSAXParser();
        }
        catch (Exception e) {
            this.log.error("Digester.getParser: ", e);
            return null;
        }
        return this.parser;
    }

    public Object getProperty(String property) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(property);
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean getRulesValidation() {
        return this.rulesValidation;
    }

    public void setRulesValidation(boolean rulesValidation) {
        this.rulesValidation = rulesValidation;
    }

    public Map<Class<?>, List<String>> getFakeAttributes() {
        return this.fakeAttributes;
    }

    public boolean isFakeAttribute(Object object, String name) {
        if (this.fakeAttributes == null) {
            return false;
        }
        List<String> result = this.fakeAttributes.get(object.getClass());
        if (result == null) {
            result = this.fakeAttributes.get(Object.class);
        }
        if (result == null) {
            return false;
        }
        return result.contains(name);
    }

    public void setFakeAttributes(Map<Class<?>, List<String>> fakeAttributes) {
        this.fakeAttributes = fakeAttributes;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
        }
        this.reader.setDTDHandler(this);
        this.reader.setContentHandler(this);
        if (this.entityResolver == null) {
            this.reader.setEntityResolver(this);
        } else {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    @Override
    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("characters(" + new String(buffer, start, length) + ")");
        }
        this.bodyText.append(buffer, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            if (this.getCount() > 1) {
                this.saxLog.debug("endDocument():  " + this.getCount() + " elements left");
            } else {
                this.saxLog.debug("endDocument()");
            }
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        for (Rule rule : this.getRules().rules()) {
            try {
                rule.finish();
            }
            catch (Exception e) {
                this.log.error("Finish event threw exception", e);
                throw this.createSAXException(e);
            }
            catch (Error e) {
                this.log.error("Finish event threw error", e);
                throw e;
            }
        }
        this.clear();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        int slash;
        Rule rule;
        List<Rule> rules;
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            if (this.saxLog.isDebugEnabled()) {
                this.saxLog.debug("endElement(" + namespaceURI + "," + localName + "," + qName + ")");
            }
            this.log.debug("  match='" + this.match + "'");
            this.log.debug("  bodyText='" + this.bodyText + "'");
        }
        this.bodyText = this.updateBodyText(this.bodyText);
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        if ((rules = this.matches.pop()) != null && rules.size() > 0) {
            String bodyText = this.bodyText.toString();
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    rule = rules.get(i);
                    if (debug) {
                        this.log.debug("  Fire body() for " + rule);
                    }
                    rule.body(namespaceURI, name, bodyText);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Body event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("Body event threw error", e);
                    throw e;
                }
            }
        } else {
            if (debug) {
                this.log.debug("  No rules found matching '" + this.match + "'.");
            }
            if (this.rulesValidation) {
                this.log.warn("  No rules found matching '" + this.match + "'.");
            }
        }
        this.bodyText = this.bodyTexts.pop();
        if (rules != null) {
            for (int i = 0; i < rules.size(); ++i) {
                int j = rules.size() - i - 1;
                try {
                    rule = rules.get(j);
                    if (debug) {
                        this.log.debug("  Fire end() for " + rule);
                    }
                    rule.end(namespaceURI, name);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("End event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("End event threw error", e);
                    throw e;
                }
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        ArrayStack<String> stack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("endPrefixMapping(" + prefix + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            return;
        }
        try {
            stack.pop();
            if (stack.empty()) {
                this.namespaces.remove(prefix);
            }
        }
        catch (EmptyStackException e) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    @Override
    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("ignorableWhitespace(" + new String(buffer, start, len) + ")");
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("processingInstruction('" + target + "','" + data + "')");
        }
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("setDocumentLocator(" + locator + ")");
        }
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("skippedEntity(" + name + ")");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startDocument()");
        }
        if (this.locator instanceof Locator2) {
            if (this.root instanceof DocumentProperties.Charset) {
                String enc = ((Locator2)this.locator).getEncoding();
                if (enc != null) {
                    try {
                        ((DocumentProperties.Charset)this.root).setCharset(B2CConverter.getCharset(enc));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.warn(sm.getString("disgester.encodingInvalid", enc), e);
                    }
                }
            } else if (this.root instanceof DocumentProperties.Encoding) {
                ((DocumentProperties.Encoding)this.root).setEncoding(((Locator2)this.locator).getEncoding());
            }
        }
        this.configure();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        boolean debug = this.log.isDebugEnabled();
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startElement(" + namespaceURI + "," + localName + "," + qName + ")");
        }
        list = this.updateAttributes(list);
        this.bodyTexts.push(this.bodyText);
        this.bodyText = new StringBuilder();
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        StringBuilder sb = new StringBuilder(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        sb.append(name);
        this.match = sb.toString();
        if (debug) {
            this.log.debug("  New match='" + this.match + "'");
        }
        List<Rule> rules = this.getRules().match(namespaceURI, this.match);
        this.matches.push(rules);
        if (rules != null && rules.size() > 0) {
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    Rule rule = rules.get(i);
                    if (debug) {
                        this.log.debug("  Fire begin() for " + rule);
                    }
                    rule.begin(namespaceURI, name, list);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Begin event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("Begin event threw error", e);
                    throw e;
                }
            }
        } else if (debug) {
            this.log.debug("  No rules found matching '" + this.match + "'.");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        ArrayStack<String> stack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startPrefixMapping(" + prefix + "," + namespaceURI + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            stack = new ArrayStack();
            this.namespaces.put(prefix, stack);
        }
        stack.push(namespaceURI);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("notationDecl(" + name + "," + publicId + "," + systemId + ")");
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("unparsedEntityDecl(" + name + "," + publicId + "," + systemId + "," + notation + ")");
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String entityURL;
        block13: {
            if (this.saxLog.isDebugEnabled()) {
                this.saxLog.debug("resolveEntity('" + publicId + "', '" + systemId + "', '" + baseURI + "')");
            }
            entityURL = null;
            if (publicId != null) {
                entityURL = this.entityValidator.get(publicId);
            }
            if (entityURL == null) {
                if (systemId == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(" Cannot resolve entity: '" + publicId + "'");
                    }
                    return null;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(" Trying to resolve using system ID '" + systemId + "'");
                }
                entityURL = systemId;
                if (baseURI != null) {
                    try {
                        URI uri = new URI(systemId);
                        if (!uri.isAbsolute()) {
                            entityURL = new URI(baseURI).resolve(uri).toString();
                        }
                    }
                    catch (URISyntaxException e) {
                        if (!this.log.isDebugEnabled()) break block13;
                        this.log.debug("Invalid URI '" + baseURI + "' or '" + systemId + "'");
                    }
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Resolving to alternate DTD '" + entityURL + "'");
        }
        try {
            return new InputSource(entityURL);
        }
        catch (Exception e) {
            throw this.createSAXException(e);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.setPublicId(publicId);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log.error("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log.error("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.log.warn("Parse Warning Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
            this.errorHandler.warning(exception);
        }
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        InputSource input = new InputSource(new FileInputStream(file));
        input.setSystemId("file://" + file.getAbsolutePath());
        this.getXMLReader().parse(input);
        return this.root;
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        this.configure();
        this.getXMLReader().parse(input);
        return this.root;
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.configure();
        InputSource is = new InputSource(input);
        this.getXMLReader().parse(is);
        return this.root;
    }

    public void register(String publicId, String entityURL) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("register('" + publicId + "', '" + entityURL + "'");
        }
        this.entityValidator.put(publicId, entityURL);
    }

    public void addRule(String pattern, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(pattern, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String oldNamespaceURI = this.getRuleNamespaceURI();
        String newNamespaceURI = ruleSet.getNamespaceURI();
        if (this.log.isDebugEnabled()) {
            if (newNamespaceURI == null) {
                this.log.debug("addRuleSet() with no namespace URI");
            } else {
                this.log.debug("addRuleSet() with namespace URI " + newNamespaceURI);
            }
        }
        this.setRuleNamespaceURI(newNamespaceURI);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(oldNamespaceURI);
    }

    public void addCallMethod(String pattern, String methodName) {
        this.addRule(pattern, new CallMethodRule(methodName));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new CallParamRule(paramIndex));
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory creationFactory, boolean ignoreCreateExceptions) {
        creationFactory.setDigester(this);
        this.addRule(pattern, new FactoryCreateRule(creationFactory, ignoreCreateExceptions));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new ObjectCreateRule(className));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new ObjectCreateRule(className, attributeName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetNextRule(methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesRule());
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
        this.log = null;
        this.saxLog = null;
        this.configured = false;
    }

    public void reset() {
        this.root = null;
        this.setErrorHandler(null);
        this.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    public Object getRoot() {
        return this.root;
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.log = LogFactory.getLog("org.apache.tomcat.util.digester.Digester");
        this.saxLog = LogFactory.getLog("org.apache.tomcat.util.digester.Digester.sax");
        this.configured = true;
    }

    public Object peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object popParams() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Popping params");
            }
            return this.params.pop();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public void pushParams(Object object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Pushing params");
        }
        this.params.push(object);
    }

    public SAXException createSAXException(String message, Exception e) {
        if (e != null && e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof VirtualMachineError) {
                throw (VirtualMachineError)t;
            }
            if (t instanceof Exception) {
                e = (Exception)t;
            }
        }
        if (this.locator != null) {
            String error = "Error at (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ") : " + message;
            if (e != null) {
                return new SAXParseException(error, this.locator, e);
            }
            return new SAXParseException(error, this.locator);
        }
        this.log.error("No Locator!");
        if (e != null) {
            return new SAXException(message, e);
        }
        return new SAXException(message);
    }

    public SAXException createSAXException(Exception e) {
        if (e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof VirtualMachineError) {
                throw (VirtualMachineError)t;
            }
            if (t instanceof Exception) {
                e = (Exception)t;
            }
        }
        return this.createSAXException(e.getMessage(), e);
    }

    public SAXException createSAXException(String message) {
        return this.createSAXException(message, null);
    }

    private Attributes updateAttributes(Attributes list) {
        if (list.getLength() == 0) {
            return list;
        }
        AttributesImpl newAttrs = new AttributesImpl(list);
        int nAttributes = newAttrs.getLength();
        for (int i = 0; i < nAttributes; ++i) {
            String value = newAttrs.getValue(i);
            try {
                String newValue = IntrospectionUtils.replaceProperties(value, null, this.source);
                if (value == newValue) continue;
                newAttrs.setValue(i, newValue);
                continue;
            }
            catch (Exception e) {
                this.log.warn(sm.getString("digester.failedToUpdateAttributes", newAttrs.getLocalName(i), value), e);
            }
        }
        return newAttrs;
    }

    private StringBuilder updateBodyText(StringBuilder bodyText) {
        String out;
        String in = bodyText.toString();
        try {
            out = IntrospectionUtils.replaceProperties(in, null, this.source);
        }
        catch (Exception e) {
            return bodyText;
        }
        if (out == in) {
            return bodyText;
        }
        return new StringBuilder(out);
    }

    static {
        propertySourceSet = false;
        sm = StringManager.getManager(Digester.class);
        String className = System.getProperty("org.apache.tomcat.util.digester.PROPERTY_SOURCE");
        IntrospectionUtils.PropertySource source = null;
        if (className != null) {
            ClassLoader[] cls = new ClassLoader[]{Digester.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
            for (int i = 0; i < cls.length; ++i) {
                try {
                    Class<?> clazz = Class.forName(className, true, cls[i]);
                    source = (IntrospectionUtils.PropertySource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    LogFactory.getLog("org.apache.tomcat.util.digester.Digester").error("Unable to load property source[" + className + "].", t);
                    continue;
                }
            }
        }
        if (source != null) {
            propertySource = source;
            propertySourceSet = true;
        }
        if (Boolean.getBoolean("org.apache.tomcat.util.digester.REPLACE_SYSTEM_PROPERTIES")) {
            Digester.replaceSystemProperties();
        }
    }

    private class SystemPropertySource
    implements IntrospectionUtils.PropertySource {
        private SystemPropertySource() {
        }

        @Override
        public String getProperty(String key) {
            PropertyPermission p;
            ClassLoader cl = Digester.this.getClassLoader();
            if (cl instanceof PermissionCheck && !((PermissionCheck)((Object)cl)).check(p = new PropertyPermission(key, "read"))) {
                return null;
            }
            return System.getProperty(key);
        }
    }
}

