/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber;

import com.google.common.collect.Lists;
import cucumber.runtime.junit.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import minium.cucumber.data.ProfilesMatrix;
import minium.cucumber.internal.CucumberContext;
import minium.cucumber.internal.MiniumActiveProfilesResolver;
import minium.cucumber.internal.MiniumProfileRunner;
import minium.cucumber.internal.MiniumRhinoTestContextManager;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class MiniumCucumber
extends ParentRunner<MiniumProfileRunner> {
    private List<MiniumProfileRunner> children = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniumCucumber(Class<?> clazz) throws InitializationError, IOException {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods(clazz);
        for (String[] profiles : this.getProfilesMatrix().getMatrix()) {
            MiniumActiveProfilesResolver.setActiveProfiles(profiles);
            try {
                MiniumRhinoTestContextManager testContextManager = new MiniumRhinoTestContextManager(MiniumProfileRunner.MiniumCucumberTest.class);
                MiniumProfileRunner profileRunner = (MiniumProfileRunner)((Object)testContextManager.getBeanFactory().createBean(MiniumProfileRunner.class));
                profileRunner.setTestContextManager(testContextManager);
                this.children.add(profileRunner);
            }
            finally {
                MiniumActiveProfilesResolver.setActiveProfiles(new String[0]);
            }
        }
    }

    private ProfilesMatrix getProfilesMatrix() {
        String profilesMatrixStr = System.getProperty("minium.cucumber.matrix", "");
        ProfilesMatrix profilesMatrix = new ProfilesMatrix(profilesMatrixStr);
        CucumberContext.setProfilesMatrix(profilesMatrix);
        return profilesMatrix;
    }

    public List<MiniumProfileRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(MiniumProfileRunner child) {
        return child.getDescription();
    }

    protected void runChild(MiniumProfileRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    static {
        System.setProperty("spring.main.banner-mode", "off");
        System.setProperty("minium.resources.dir", new File("src/test/resources").getAbsolutePath());
    }
}

