/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import minium.actions.Interaction;
import minium.actions.InteractionListener;
import minium.actions.internal.AbstractInteraction;
import minium.actions.internal.AfterFailInteractionEvent;
import minium.actions.internal.DefaultInteractionListener;
import minium.web.actions.OnExceptionInteractionListener;

public class DefaultOnExceptionInteractionListener
extends DefaultInteractionListener
implements OnExceptionInteractionListener {
    private Set<Class<? extends Throwable>> exceptions;
    private boolean retry = true;

    public DefaultOnExceptionInteractionListener(Class<? extends Throwable> ... exceptions) {
        this.exceptions = ImmutableSet.copyOf((Object[])exceptions);
    }

    protected boolean handle(AfterFailInteractionEvent event) {
        Interaction interaction = event.getInteraction();
        if (interaction instanceof AbstractInteraction) {
            ((AbstractInteraction)interaction).refreeze();
        }
        return true;
    }

    protected final void onAfterFailEvent(AfterFailInteractionEvent event) {
        boolean handle;
        boolean canHandleException = FluentIterable.from((Iterable)Throwables.getCausalChain((Throwable)event.getException())).anyMatch((Predicate)new Predicate<Throwable>(){

            public boolean apply(Throwable throwable) {
                return DefaultOnExceptionInteractionListener.this.exceptions.contains(throwable.getClass());
            }
        });
        if (canHandleException && (handle = this.handle(event)) && this.retry) {
            event.setRetry(this.retry);
        }
    }

    @Override
    public InteractionListener thenAbort() {
        this.retry = false;
        return this;
    }

    @Override
    public InteractionListener thenRetry() {
        this.retry = true;
        return this;
    }
}

