/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Observable;
import java.util.Observer;
import minium.web.DelegatorWebDriver;
import minium.web.internal.drivers.BaseDocumentWebDriver;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowDelegatorWebDriver
extends BaseDocumentWebDriver
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowDelegatorWebDriver.class);
    private String windowHandle;

    public WindowDelegatorWebDriver(DelegatorWebDriver webDriver) {
        super(webDriver);
        webDriver.addObserver(this);
        WebDriver delegateWebDriver = webDriver.getDelegate();
        if (delegateWebDriver != null) {
            this.windowHandle = delegateWebDriver.getWindowHandle();
        }
    }

    @Override
    public void ensureSwitch() {
        Preconditions.checkState((this.windowHandle != null ? 1 : 0) != 0);
        this.webDriver.switchTo().window(this.windowHandle);
        LOGGER.trace("Switched to window {}", (Object)this.windowHandle);
    }

    @Override
    public boolean isClosed() {
        Preconditions.checkState((this.windowHandle != null ? 1 : 0) != 0);
        return !this.getWindowHandles().contains(this.windowHandle);
    }

    @Override
    public void quit() {
        super.quit();
        ((DelegatorWebDriver)this.webDriver).deleteObserver(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)WindowDelegatorWebDriver.class.getSimpleName()).addValue((Object)this.webDriver).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.webDriver});
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == WindowDelegatorWebDriver.class && this.equalFields((WindowDelegatorWebDriver)obj);
    }

    protected boolean equalFields(WindowDelegatorWebDriver obj) {
        return super.equalFields(obj) && Objects.equal((Object)this.webDriver, (Object)obj.webDriver);
    }

    @Override
    public void update(Observable o, Object arg) {
        WebDriver webDriver = (WebDriver)arg;
        this.windowHandle = webDriver == null ? null : webDriver.getWindowHandle();
    }
}

