/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import minium.FreezableElements;
import minium.internal.BaseElements;
import minium.internal.HasElementsFactory;
import minium.web.DocumentWebDriver;
import minium.web.WebElements;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.HasJavascriptInvoker;
import minium.web.internal.HasNativeWebDriver;
import minium.web.internal.WebElementFunctions;
import minium.web.internal.WebElementsFactory;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.drivers.JavascriptInvoker;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.VariableGenerator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InternalWebElements
extends WebElements {
    public Iterable<DocumentWebDriver> candidateDocumentDrivers();

    public DocumentWebDriver documentDriver();

    public Iterable<DocumentWebDriver> documentDrivers();

    public WebElements documentRoots();

    public WebElements candidateDocumentRoots();

    public boolean isDocumentRoots();

    public Iterable<WebElement> computeNativeElements(DocumentWebDriver var1);

    public Iterable<DocumentWebElement> wrappedNativeElements();

    public static abstract class Impl<T extends WebElements>
    extends BaseElements<T>
    implements InternalWebElements,
    FreezableElements<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(Impl.class);

        @Override
        public DocumentWebDriver documentDriver() {
            Iterator documentDriversIterator = this.documentDrivers().iterator();
            DocumentWebDriver documentDriver = (DocumentWebDriver)Iterators.getNext(documentDriversIterator, null);
            Preconditions.checkState((!documentDriversIterator.hasNext() ? 1 : 0) != 0, (Object)"found multiple document drivers for this web element (call documentDrivers insteand)");
            return documentDriver;
        }

        @Override
        public Iterable<DocumentWebElement> wrappedNativeElements() {
            ImmutableSet nativeElems = FluentIterable.from((Iterable)this.candidateDocumentDrivers()).transformAndConcat((Function)new DocumentWebDriverNativeElementsFetcher()).toSet();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} elements evaluated for {}", (Object)Iterables.size((Iterable)nativeElems), this.myself());
            }
            return nativeElems;
        }

        @Override
        public Iterable<WebElement> computeNativeElements(DocumentWebDriver wd) {
            Expression expression = ((ExpressionWebElements)this.as(ExpressionWebElements.class)).getExpression();
            VariableGenerator.Impl varGenerator = new VariableGenerator.Impl();
            String javascript = expression.getJavascript(varGenerator);
            Object[] args = expression.getArgs();
            if (args == null) {
                args = new Object[]{};
            }
            Preconditions.checkState((varGenerator.usedVariables() == args.length ? 1 : 0) != 0);
            return (Iterable)this.javascriptInvoker().invokeExpression(wd, javascript, args);
        }

        protected WebDriver nativeWebDriver() {
            return ((HasNativeWebDriver)this.as(HasNativeWebDriver.class)).nativeWebDriver();
        }

        protected JavascriptInvoker javascriptInvoker() {
            return this.is(HasJavascriptInvoker.class) ? ((HasJavascriptInvoker)this.as(HasJavascriptInvoker.class)).javascriptInvoker() : null;
        }

        protected WebElementsFactory<T> factory() {
            TypeToken factoryTypeToken = this.typeTokenFor(WebElementsFactory.class);
            return (WebElementsFactory)((HasElementsFactory)this.as(HasElementsFactory.class)).factory().as(factoryTypeToken);
        }

        private final class DocumentWebDriverNativeElementsFetcher
        implements Function<DocumentWebDriver, Iterable<DocumentWebElement>> {
            private DocumentWebDriverNativeElementsFetcher() {
            }

            public Iterable<DocumentWebElement> apply(DocumentWebDriver wd) {
                return FluentIterable.from(Impl.this.computeNativeElements(wd)).transform(WebElementFunctions.wrap(wd));
            }
        }
    }
}

