/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cucumber.runtime.Backend;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import minium.cucumber.formatter.ProgressFormatter;

public class RuntimeBuilder {
    private Class<?> testClass;
    private ClassLoader classLoader;
    private ResourceLoader resourceLoader;
    private final List<String> featurePaths = Lists.newArrayList();
    private final List<Backend> backends = Lists.newArrayList();
    private final List<Object> plugins = Lists.newArrayList();
    private PluginFactory pluginFactory;
    private RuntimeOptions runtimeOptions;
    private final List<String> args = Lists.newArrayList();
    private Runtime runtime;

    public RuntimeBuilder withTestClass(Class<?> testClass) {
        this.testClass = testClass;
        return this;
    }

    public RuntimeBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public RuntimeBuilder withResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    public RuntimeBuilder withPluginFactory(PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        return this;
    }

    public RuntimeBuilder withRuntimeOptions(RuntimeOptions runtimeOptions) {
        this.runtimeOptions = runtimeOptions;
        return this;
    }

    public RuntimeBuilder withBackends(Backend ... backends) {
        return this.withBackends(Arrays.asList(backends));
    }

    public RuntimeBuilder withBackends(List<Backend> backends) {
        this.backends.addAll(backends);
        return this;
    }

    public RuntimeBuilder withArgs(String ... args) {
        return this.withArgs(Arrays.asList(args));
    }

    public RuntimeBuilder withArgs(Collection<String> args) {
        this.args.addAll(args);
        return this;
    }

    public RuntimeBuilder withFeaturePaths(String ... args) {
        return this.withFeaturePaths(Arrays.asList(args));
    }

    public RuntimeBuilder withFeaturePaths(Collection<String> featurePaths) {
        this.featurePaths.addAll(featurePaths);
        return this;
    }

    public RuntimeBuilder withPlugins(Object ... plugins) {
        return this.withPlugins(Arrays.asList(plugins));
    }

    public RuntimeBuilder withPlugins(Collection<?> plugins) {
        this.plugins.addAll(plugins);
        return this;
    }

    public Runtime build() {
        if (this.classLoader == null) {
            ClassLoader classLoader = this.classLoader = this.testClass == null ? Thread.currentThread().getContextClassLoader() : this.testClass.getClassLoader();
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = new MultiLoader(this.classLoader);
        }
        if (this.pluginFactory == null) {
            this.pluginFactory = new PluginFactory();
        }
        if (this.runtimeOptions == null) {
            Preconditions.checkArgument((!this.args.isEmpty() || this.testClass != null ? 1 : 0) != 0, (Object)"RuntimeOptions not provided, need args or testClass");
            this.runtimeOptions = this.args.isEmpty() ? new RuntimeOptionsFactory(this.testClass).create() : new RuntimeOptions(this.pluginFactory, this.args);
        }
        this.runtimeOptions.getFeaturePaths().addAll(this.featurePaths);
        for (Object plugin : this.plugins) {
            this.runtimeOptions.addPlugin(plugin);
        }
        String progressOutputFilePath = System.getProperty("minium.cucumber.progressOutputFile", null);
        if (progressOutputFilePath != null) {
            File progressOutputFile = new File(progressOutputFilePath);
            this.runtimeOptions.addPlugin((Object)new ProgressFormatter(progressOutputFile));
        }
        this.runtime = new Runtime(this.resourceLoader, this.classLoader, this.backends, this.runtimeOptions);
        return this.runtime;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public RuntimeOptions getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }
}

