/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cucumber.api.PendingException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import minium.cucumber.StepListener;
import org.junit.runner.notification.RunNotifier;

public class ListenerReporter
implements Reporter,
Formatter {
    private final List<StepListener> stepListeners = Lists.newArrayList();
    private final List<Step> steps = Lists.newArrayList();
    private final boolean strict;
    private Step matchedStep;
    private boolean ignoredStep;
    private boolean inScenarioLifeCycle;
    private boolean inScenarioOutilne;
    private Queue<Object> exampleOfScenarioOutline;
    private int lastExampleLine;
    private boolean lastExample;

    public ListenerReporter() {
        this(true);
    }

    public ListenerReporter add(StepListener ... listeners) {
        this.stepListeners.addAll((Collection<StepListener>)ImmutableList.copyOf((Object[])listeners));
        return this;
    }

    public ListenerReporter(boolean strict) {
        this.strict = strict;
    }

    public void startExecutionUnit(ExecutionUnitRunner executionUnitRunner, RunNotifier runNotifier) {
        this.ignoredStep = false;
        this.inScenarioOutilne = false;
    }

    public void finishExecutionUnit() {
        if (this.ignoredStep) {
            this.fireTestIgnored();
        }
        this.fireTestFinished(null);
    }

    public void match(Match match) {
        this.matchedStep = this.steps.remove(0);
        this.fireMatch();
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }

    public void result(Result result) {
        Throwable error = result.getError();
        if (Result.SKIPPED == result) {
            this.fireTestIgnored();
        } else if (this.isPendingOrUndefined(result)) {
            this.addFailureOrIgnoreStep(result);
        } else {
            if (this.matchedStep != null) {
                this.fireTestStarted();
                if (error != null) {
                    this.fireFailure(result);
                }
                this.fireTestFinished(result);
            }
            if (error != null) {
                this.fireFailure(result);
            }
        }
        if (this.steps.isEmpty()) {
            this.matchedStep = null;
        }
        if ((this.inScenarioOutilne || this.lastExample) && error != null) {
            int line = this.lastExampleLine;
            this.fireTestFailedExample(line);
        }
    }

    private boolean isPendingOrUndefined(Result result) {
        Throwable error = result.getError();
        return Result.UNDEFINED == result || Runtime.isPending((Throwable)error);
    }

    private void addFailureOrIgnoreStep(Result result) {
        if (this.strict) {
            this.fireTestStarted();
            this.fireFailure(result);
            this.fireTestFinished(result);
        } else {
            this.ignoredStep = true;
            this.fireTestIgnored();
        }
    }

    public void before(Match match, Result result) {
        this.handleHook(result);
    }

    public void after(Match match, Result result) {
        this.handleHook(result);
    }

    private void handleHook(Result result) {
        if (result.getStatus().equals("failed")) {
            this.fireFailure(result);
        }
    }

    public void uri(String uri) {
    }

    public void feature(Feature feature) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.inScenarioOutilne = true;
        this.lastExample = false;
    }

    public void examples(Examples examples) {
        this.exampleOfScenarioOutline = new LinkedList<Object>();
        for (ExamplesTableRow example : examples.getRows()) {
            this.exampleOfScenarioOutline.add(example.getLine());
        }
        this.exampleOfScenarioOutline.remove();
    }

    public void step(Step step) {
        if (this.inScenarioLifeCycle) {
            this.steps.add(step);
        }
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
    }

    public void close() {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.inScenarioLifeCycle = true;
        if (this.inScenarioOutilne) {
            int line = (Integer)this.exampleOfScenarioOutline.element();
            this.fireTestStartedExample(line);
            this.lastExampleLine = line;
            this.exampleOfScenarioOutline.remove();
            if (this.exampleOfScenarioOutline.isEmpty()) {
                this.inScenarioOutilne = false;
                this.lastExample = true;
            }
        }
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.inScenarioLifeCycle = false;
    }

    private void fireFailure(Result result) {
        Throwable error = result.getError();
        if (error == null) {
            error = new PendingException();
        }
        for (StepListener stepListener : this.stepListeners) {
            stepListener.failedStep(this.matchedStep, error);
        }
    }

    private void fireMatch() {
        Preconditions.checkNotNull((Object)this.matchedStep);
        for (StepListener stepListener : this.stepListeners) {
            stepListener.beforeStep(this.matchedStep);
        }
    }

    protected void fireTestStarted() {
    }

    protected void fireTestFinished(Result result) {
        if (result == null) {
            return;
        }
        Preconditions.checkNotNull((Object)this.matchedStep);
        for (StepListener stepListener : this.stepListeners) {
            stepListener.afterStep(this.matchedStep, result);
        }
    }

    protected void fireTestIgnored() {
        Preconditions.checkNotNull((Object)this.matchedStep);
        for (StepListener stepListener : this.stepListeners) {
            stepListener.ignoredStep(this.matchedStep);
        }
    }

    protected void fireTestStartedExample(int line) {
        for (StepListener stepListener : this.stepListeners) {
            stepListener.exampleStep(line);
        }
    }

    protected void fireTestFailedExample(int line) {
        for (StepListener stepListener : this.stepListeners) {
            stepListener.failedExampleStep(line);
        }
    }
}

