/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.config;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import cucumber.api.SnippetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import minium.cucumber.rest.RemoteBackend;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class CucumberProperties {
    private OptionsProperties options = new OptionsProperties();
    private List<RemoteBackendProperties> remoteBackends = Lists.newArrayList();
    private List<SnippetProperties> snippets = Lists.newArrayList();

    public OptionsProperties getOptions() {
        return this.options;
    }

    public void setOptions(OptionsProperties options) {
        this.options = options;
    }

    public List<RemoteBackendProperties> getRemoteBackends() {
        return this.remoteBackends;
    }

    public void setRemoteBackends(Collection<RemoteBackendProperties> remoteBackends) {
        this.remoteBackends = Lists.newArrayList(remoteBackends);
    }

    public List<SnippetProperties> getSnippets() {
        return this.snippets;
    }

    public void setSnippets(List<SnippetProperties> snippets) {
        this.snippets = snippets;
    }

    public static class SnippetProperties {
        private String name;
        private String content;
        private String trigger;
        private List<String> rowsHashKeys = Lists.newArrayList();
        private List<String> hashesKeys = Lists.newArrayList();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContent() {
            if (this.content == null) {
                List parts = Splitter.on((String)"...").splitToList((CharSequence)this.name);
                StringBuilder buf = new StringBuilder();
                int curr = 1;
                for (int i = 0; i < parts.size(); ++i) {
                    buf.append((String)parts.get(i));
                    if (i == parts.size() - 1) continue;
                    buf.append("${" + curr++ + ":value}");
                }
                if (!this.rowsHashKeys.isEmpty()) {
                    buf.append("\n");
                    buf.append("  | " + Joiner.on((String)" | ").join(this.rowsHashKeys) + " |\n");
                    buf.append("  |");
                    for (String col : this.rowsHashKeys) {
                        buf.append(" ${" + curr++ + ":" + col + "} ");
                        buf.append("|");
                    }
                }
                if (!this.hashesKeys.isEmpty()) {
                    for (String col : this.hashesKeys) {
                        buf.append("\n");
                        buf.append("  | " + col + "  | ");
                        buf.append(" ${" + curr++ + ":" + col + "} ");
                        buf.append("|");
                    }
                }
                return buf.toString();
            }
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getTrigger() {
            if (this.trigger == null) {
                return this.name.replaceAll("\\s+.*", "");
            }
            return this.trigger;
        }

        public void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        public List<String> getRowsHashKeys() {
            return this.rowsHashKeys;
        }

        public void setRowsHashKeys(List<String> rowsHashKeys) {
            this.rowsHashKeys = rowsHashKeys;
        }

        public List<String> getHashesKeys() {
            return this.hashesKeys;
        }

        public void setHashesKeys(List<String> hashesKeys) {
            this.hashesKeys = hashesKeys;
        }
    }

    public static class RemoteBackendProperties {
        private CredentialsProperties credentials;
        private String url;

        public CredentialsProperties getCredentials() {
            return this.credentials;
        }

        public void setCredentials(CredentialsProperties credentials) {
            this.credentials = credentials;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public RemoteBackend createRemoteBackend() {
            CloseableHttpClient httpClient;
            if (this.credentials != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.credentials.getUsername(), this.credentials.getPassword()));
                httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            } else {
                httpClient = HttpClientBuilder.create().build();
            }
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
            return new RemoteBackend(this.url, restTemplate);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RemoteBackendProperties) {
                RemoteBackendProperties other = (RemoteBackendProperties)obj;
                return Objects.equal((Object)this.url, (Object)other.url) && Objects.equal((Object)this.credentials, (Object)other.credentials);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.url, this.credentials});
        }
    }

    public static class CredentialsProperties {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CredentialsProperties) {
                CredentialsProperties other = (CredentialsProperties)obj;
                return Objects.equal((Object)this.username, (Object)other.username) && Objects.equal((Object)this.password, (Object)other.password);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.username, this.password});
        }
    }

    public static class OptionsProperties {
        private static final String CUCUMBER_RUNTIME_MINIUM = "classpath:minium/cucumber/internal/hooks";
        private boolean dryRun;
        private boolean strict = true;
        private List<String> features = Lists.newArrayList(Arrays.asList("src/test/resources/features"));
        private List<String> glue = Lists.newArrayList(Arrays.asList("classpath:minium/cucumber/internal/hooks", "src/test/resources/steps"));
        private List<String> tags = Lists.newArrayList();
        private List<String> format = Lists.newArrayList();
        private List<String> plugin = Lists.newArrayList();
        private boolean monochrome;
        private List<String> name = Lists.newArrayList();
        private SnippetType snippets = SnippetType.UNDERSCORE;

        public boolean isDryRun() {
            return this.dryRun;
        }

        public void setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public List<String> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<String> features) {
            this.features = features;
        }

        public List<String> getGlue() {
            return this.glue;
        }

        public void setGlue(List<String> glue) {
            this.glue = glue;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public List<String> getFormat() {
            return this.format;
        }

        public void setFormat(List<String> format) {
            this.format = format;
        }

        public List<String> getPlugin() {
            return this.plugin;
        }

        public void setPlugin(List<String> plugin) {
            this.plugin = plugin;
        }

        public boolean isMonochrome() {
            return this.monochrome;
        }

        public void setMonochrome(boolean monochrome) {
            this.monochrome = monochrome;
        }

        public List<String> getName() {
            return this.name;
        }

        public void setName(List<String> name) {
            this.name = name;
        }

        public SnippetType getSnippets() {
            return this.snippets;
        }

        public void setSnippets(SnippetType snippets) {
            this.snippets = snippets;
        }

        public List<String> toArgs() {
            ArrayList args = Lists.newArrayList();
            if (this.dryRun) {
                args.add("--dry-run");
            }
            if (this.strict) {
                args.add("--strict");
            }
            if (this.monochrome) {
                args.add("--monochrome");
            }
            for (String gl : ImmutableSet.copyOf(this.glue)) {
                args.add("--glue");
                args.add(gl);
            }
            if (!this.plugin.isEmpty()) {
                for (String pl : ImmutableSet.copyOf(this.plugin)) {
                    args.add("--plugin");
                    args.add(pl);
                }
            } else {
                args.add("--plugin");
                args.add("null");
            }
            for (String t : ImmutableSet.copyOf(this.tags)) {
                args.add("--tags");
                args.add(t);
            }
            for (String nm : ImmutableSet.copyOf(this.name)) {
                args.add("--name");
                args.add(nm);
            }
            args.add("--snippets");
            args.add(this.snippets.toString());
            args.addAll(ImmutableSet.copyOf(this.features));
            return args;
        }
    }
}

