/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.assertj.core.util.Closeables;

public class TextFileWriter {
    private static final TextFileWriter INSTANCE = new TextFileWriter();

    public static TextFileWriter instance() {
        return INSTANCE;
    }

    public void write(File file, String ... content) throws IOException {
        this.write(file, Charset.defaultCharset(), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Charset charset, String ... content) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
            for (String line : content) {
                writer.println(line);
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly(writer);
    }

    private TextFileWriter() {
    }
}

