/*
 * Decompiled with CFR 0.152.
 */
package platypus.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import platypus.IncompleteImplementationException;
import platypus.InstanceProvider;
import platypus.InstanceProviders;
import platypus.Mixin;
import platypus.MixinImplementor;
import platypus.MixinInitializer;
import platypus.internal.Casts;
import platypus.internal.Classes;
import platypus.internal.MixinClassImpl;

public class ProxyInvocationHandler<T>
implements InvocationHandler,
MixinImplementor {
    static final Logger LOGGER = LoggerFactory.getLogger(ProxyInvocationHandler.class);
    static final Predicate<Class<?>> WITH_DECLARED_METHODS_FN = new Predicate<Class<?>>(){

        public boolean apply(Class<?> clazz) {
            return clazz.getDeclaredMethods().length > 0;
        }
    };
    static final Function<Class<?>, Iterable<Class<?>>> ALL_INTFS_FN = new Function<Class<?>, Iterable<Class<?>>>(){

        public Iterable<Class<?>> apply(Class<?> clazz) {
            return Classes.getInterfacesClosure(clazz);
        }
    };
    static final Function<InterfacesInstanceProvider, Iterable<Class<?>>> PROVIDER_IMPLEMENTED_INTFS_FN = new Function<InterfacesInstanceProvider, Iterable<Class<?>>>(){

        public Iterable<Class<?>> apply(InterfacesInstanceProvider provider) {
            return provider.getImplementedInterfaces();
        }
    };
    private final MixinClassImpl<T> mixinClass;
    private final T proxy;
    private final List<InterfacesInstanceProvider> providers = Lists.newArrayList();
    private final LinkedHashMap<Class<?>, Object> impls = Maps.newLinkedHashMap();

    public ProxyInvocationHandler(MixinClassImpl<T> mixinClass, MixinInitializer initializer) {
        this.mixinClass = mixinClass;
        this.proxy = this.newProxyInstance();
        initializer.initialize(this);
        ImmutableSet<Class<?>> allMixinIntfs = this.getAllInterfaces(mixinClass);
        this.checkCompleteImplementation((Set<Class<?>>)allMixinIntfs);
        this.instanciateProviders((Set<Class<?>>)allMixinIntfs);
        this.initImplementationsProxy();
    }

    private void initImplementationsProxy() {
        Set identityImpls = Sets.newIdentityHashSet();
        identityImpls.addAll(this.impls.values());
        for (Mixin.Impl impl : FluentIterable.from((Iterable)identityImpls).filter(Mixin.Impl.class)) {
            impl.setProxy(this.proxy);
        }
    }

    public <I> MixinImplementor.Implementation<I> implement(Class<I> clazz) {
        return new ImplementationImpl<I>(clazz);
    }

    @Override
    public MixinImplementor.Implementation<Object> implement(Class<?> ... clazz) {
        return this.implement(Arrays.asList(clazz));
    }

    @Override
    public MixinImplementor.Implementation<Object> implement(Collection<Class<?>> clazzes) {
        return new ImplementationImpl<Object>(clazzes);
    }

    @Override
    public MixinImplementor.Implementation<Object> implementRemainers() {
        Set<Class<?>> remainers = this.getRemainers((Set<Class<?>>)this.getAllInterfaces(this.mixinClass));
        return new ImplementationImpl<Object>(remainers);
    }

    public <I> MixinImplementor.Implementation<I> override(Class<I> clazz) {
        return new OverrideImplementationImpl<I>(clazz);
    }

    @Override
    public MixinImplementor.Implementation<Object> override(Class<?> ... clazz) {
        return this.override(Arrays.asList(clazz));
    }

    @Override
    public MixinImplementor.Implementation<Object> override(Collection<Class<?>> clazzes) {
        return new OverrideImplementationImpl<Object>(clazzes);
    }

    public T getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        Object impl = this.impls.get(declaringClass);
        if (impl == null) {
            throw new IncompleteImplementationException(String.format("No implementation could be found for %s", method));
        }
        try {
            if (Proxy.isProxyClass(impl.getClass())) {
                InvocationHandler wrappedHandler = Proxy.getInvocationHandler(impl);
                return wrappedHandler.invoke(proxy, method, args);
            }
            return method.invoke(impl, args);
        }
        catch (InvocationTargetException e) {
            throw (Throwable)Preconditions.checkNotNull((Object)e.getTargetException());
        }
    }

    protected T newProxyInstance() {
        try {
            return this.mixinClass.proxyConst.newInstance(this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void checkCompleteImplementation(Set<Class<?>> allMixinIntfs) {
        Set<Class<?>> differences = this.getRemainers(allMixinIntfs);
        if (!differences.isEmpty()) {
            throw new IncompleteImplementationException(String.format("The following interfaces are  missing: %s", Joiner.on((String)", ").join(differences)));
        }
    }

    protected ImmutableSet<Class<?>> getAllInterfaces(MixinClassImpl<T> mixinClass) {
        return FluentIterable.from(mixinClass.intfs).transformAndConcat(ALL_INTFS_FN).toSet();
    }

    protected Set<Class<?>> getRemainers(Set<Class<?>> allMixinIntfs) {
        ImmutableSet allProvidersIntfs = FluentIterable.from(this.providers).transformAndConcat(PROVIDER_IMPLEMENTED_INTFS_FN).transformAndConcat(ALL_INTFS_FN).toSet();
        ImmutableSet differences = FluentIterable.from((Iterable)Sets.difference(allMixinIntfs, (Set)allProvidersIntfs)).filter(WITH_DECLARED_METHODS_FN).toSet();
        return differences;
    }

    protected void instanciateProviders(Set<Class<?>> allMixinIntfs) {
        LOGGER.trace("Instanciating providers for [{}]", allMixinIntfs);
        for (InterfacesInstanceProvider provider : this.providers) {
            ImmutableSet allProviderIntfs = FluentIterable.from(provider.getImplementedInterfaces()).transformAndConcat(ALL_INTFS_FN).toSet();
            Object impl = provider.provide();
            for (Class intf : allProviderIntfs) {
                if (!allMixinIntfs.contains(intf) && intf != Object.class) {
                    LOGGER.trace("This Mixin class does not implement [{}], skipping its instance provider", (Object)intf);
                    continue;
                }
                if (this.impls.containsKey(intf) && !provider.overrides()) {
                    LOGGER.trace("[{}] was already implemented by prior instance provider, skipping this ones", (Object)intf);
                    continue;
                }
                boolean overrides = this.impls.containsKey(intf) && provider.overrides();
                this.impls.put(intf, impl);
                LOGGER.trace("[{}] is {} by instance of [{}]", new Object[]{overrides ? "overriden" : "implemented", intf, impl.getClass()});
            }
        }
    }

    private class OverrideImplementationImpl<I>
    extends ImplementationImpl<I> {
        public OverrideImplementationImpl(Class<I> intf) {
            super(intf);
        }

        public OverrideImplementationImpl(Collection<Class<?>> intfs) {
            super(intfs);
        }

        @Override
        public MixinImplementor with(InstanceProvider<? extends I> provider) {
            ProxyInvocationHandler.this.providers.add(new InterfacesInstanceProvider(provider, this.intfs, true));
            return ProxyInvocationHandler.this;
        }
    }

    private class ImplementationImpl<I>
    implements MixinImplementor.Implementation<I> {
        protected final Collection<Class<?>> intfs;

        public ImplementationImpl(Class<I> intf) {
            this.intfs = (Collection)Casts.unsafeCast(Collections.singleton(intf));
        }

        public ImplementationImpl(Collection<Class<?>> intfs) {
            this.intfs = intfs;
        }

        @Override
        public MixinImplementor with(I obj) {
            return this.with((InstanceProvider<? extends I>)InstanceProviders.ofInstance(obj));
        }

        @Override
        public MixinImplementor with(InvocationHandler handler) {
            return this.with(InstanceProviders.adapt(handler, this.intfs));
        }

        @Override
        public MixinImplementor with(InstanceProvider<? extends I> provider) {
            ProxyInvocationHandler.this.providers.add(new InterfacesInstanceProvider(provider, this.intfs));
            return ProxyInvocationHandler.this;
        }
    }

    private static class InterfacesInstanceProvider {
        private final InstanceProvider<?> provider;
        private final Set<Class<?>> intfs;
        private final boolean overrides;

        public InterfacesInstanceProvider(InstanceProvider<?> provider, Collection<Class<?>> intfs) {
            this(provider, intfs, false);
        }

        public InterfacesInstanceProvider(InstanceProvider<?> provider, Collection<Class<?>> intfs, boolean overrides) {
            this.provider = provider;
            this.intfs = ImmutableSet.copyOf(intfs);
            this.overrides = overrides;
        }

        public Object provide() {
            return this.provider.provide();
        }

        public Set<Class<?>> getImplementedInterfaces() {
            return this.intfs;
        }

        public boolean overrides() {
            return this.overrides;
        }
    }
}

