/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import minium.internal.ElementsFactory;
import minium.web.DocumentWebDriver;
import minium.web.WebElements;
import minium.web.internal.DefaultWebElementsFactory;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.expression.Coercer;
import minium.web.internal.expression.Expressionizer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import platypus.MixinInitializer;
import platypus.MixinInitializers;

public interface WebElementsFactory<T extends WebElements>
extends ElementsFactory<T> {
    public T createEmpty(DocumentWebDriver var1);

    public T createNative(DocumentWebDriver var1, WebElement ... var2);

    public T createNative(DocumentWebDriver var1, Collection<WebElement> var2);

    public T createNative(DocumentWebElement ... var1);

    public T createNative(Collection<DocumentWebElement> var1);

    public static class Builder<T extends WebElements>
    implements ElementsFactory.Builder<WebElementsFactory<T>> {
        private WebDriver webDriver;
        private ObjectMapper mapper = new ObjectMapper();
        private ClassLoader classLoader = Builder.class.getClassLoader();
        private Set<String> jsResources = Sets.newLinkedHashSet();
        private Set<String> cssResources = Sets.newLinkedHashSet();
        private Set<Expressionizer> expressionizers = Sets.newLinkedHashSet();
        private Set<Coercer> coercers = Sets.newLinkedHashSet();
        private Set<Class<?>> intfs = Sets.newLinkedHashSet();
        private Set<MixinInitializer> mixinInitializers = Sets.newLinkedHashSet();

        public Builder<T> withWebDriver(WebDriver webDriver) {
            this.webDriver = webDriver;
            return this;
        }

        public Builder<T> withObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder<T> withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder<T> withJsResources(String ... resources) {
            return this.withJsResources(Arrays.asList(resources));
        }

        public Builder<T> withJsResources(Collection<String> resources) {
            this.jsResources.addAll(resources);
            return this;
        }

        public Builder<T> withCssResources(String ... resources) {
            return this.withCssResources(Arrays.asList(resources));
        }

        public Builder<T> withCssResources(Collection<String> resources) {
            this.cssResources.addAll(resources);
            return this;
        }

        public Builder<T> withExpressionizers(Expressionizer ... expressionizers) {
            return this.withExpressionizers(Arrays.asList(expressionizers));
        }

        public Builder<T> withExpressionizers(Collection<Expressionizer> expressionizers) {
            this.expressionizers.addAll(expressionizers);
            return this;
        }

        public Builder<T> withCoercers(Coercer ... coercers) {
            return this.withCoercers(Arrays.asList(coercers));
        }

        public Builder<T> withCoercers(Collection<Coercer> coercers) {
            this.coercers.addAll(coercers);
            return this;
        }

        public Builder<T> implementingInterfaces(Class<?> ... intfs) {
            return this.implementingInterfaces(Arrays.asList(intfs));
        }

        public Builder<T> implementingInterfaces(Collection<Class<?>> intfs) {
            this.intfs.addAll(intfs);
            return this;
        }

        public Builder<T> usingMixinConfigurer(MixinInitializer configurer) {
            this.mixinInitializers.add(configurer);
            return this;
        }

        public WebDriver getWebDriver() {
            return this.webDriver;
        }

        public ObjectMapper getMapper() {
            return this.mapper;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Set<String> getJsResources() {
            return ImmutableSet.copyOf(this.jsResources);
        }

        public Set<String> getCssResources() {
            return ImmutableSet.copyOf(this.cssResources);
        }

        public Set<Class<?>> getIntfs() {
            return ImmutableSet.copyOf(this.intfs);
        }

        public Collection<Expressionizer> getAditionalExpressionizers() {
            return ImmutableSet.copyOf(this.expressionizers);
        }

        public Collection<Coercer> getAditionalCoercers() {
            return ImmutableSet.copyOf(this.coercers);
        }

        public MixinInitializer getMixinInitializer() {
            return MixinInitializers.combine(this.mixinInitializers);
        }

        public WebElementsFactory<T> build() {
            return new DefaultWebElementsFactory(this);
        }
    }
}

