/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import minium.Elements;
import minium.web.CannotFreezeException;
import minium.web.DocumentRoots;
import minium.web.DocumentWebDriver;
import minium.web.WebElements;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.HasJavascriptInvoker;
import minium.web.internal.InternalWebElements;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.RootExpression;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class BaseDocumentRoots<T extends WebElements>
extends InternalWebElements.Impl<T>
implements DocumentRoots,
ExpressionWebElements {
    @Override
    public WebElements documentRoots() {
        return (WebElements)this.myself();
    }

    @Override
    public WebElements candidateDocumentRoots() {
        return (WebElements)this.myself();
    }

    @Override
    public boolean isDocumentRoots() {
        return true;
    }

    @Override
    public Iterable<DocumentWebDriver> documentDrivers() {
        return this.candidateDocumentDrivers();
    }

    @Override
    public Expression getExpression() {
        return new RootExpression();
    }

    @Override
    public Iterable<WebElement> computeNativeElements(DocumentWebDriver wd) {
        if (this.is(HasJavascriptInvoker.class)) {
            return super.computeNativeElements(wd);
        }
        return Collections.singleton(wd.findElement(By.xpath((String)"/*")));
    }

    public T freeze() {
        return (T)((WebElements)this.internalFactory().createMixin((Elements)this.myself(), new FrozenRootsImpl()));
    }

    static class FrozenRootsImpl<T extends WebElements>
    extends BaseDocumentRoots<T> {
        private DocumentWebDriver frozenDriver;

        FrozenRootsImpl() {
        }

        @Override
        public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
            if (this.frozenDriver == null) {
                Iterable<DocumentWebDriver> webDrivers = ((InternalWebElements)this.parent().as(InternalWebElements.class)).candidateDocumentDrivers();
                Iterator<DocumentWebDriver> iterator = webDrivers.iterator();
                DocumentWebDriver firstWebDriver = (DocumentWebDriver)Iterators.getNext(iterator, null);
                if (iterator.hasNext()) {
                    throw new CannotFreezeException("Cannot freeze root because more than one root matched");
                }
                this.frozenDriver = firstWebDriver;
            }
            if (this.frozenDriver == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(this.frozenDriver);
        }

        public String toString() {
            return this.parent().toString() + ".freeze()";
        }
    }
}

