/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Lists;

public class AbstractSoftAssertions {
    protected final SoftProxies proxies = new SoftProxies();

    public <T, V> V proxy(Class<V> assertClass, Class<T> actualClass, T actual) {
        return this.proxies.create(assertClass, actualClass, actual);
    }

    public void fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Object ... args) {
        AssertionError error = Failures.instance().failure(String.format(failureMessage, args));
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public List<Throwable> errorsCollected() {
        return Lists.newArrayList(this.proxies.errorsCollected());
    }

    public boolean wasSuccess() {
        return this.proxies.wasSuccess();
    }
}

