/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.TarResource;
import org.apache.ant.compress.util.TarStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;

public class TarFileSet
extends ArchiveFileSet {
    private boolean userNameSet;
    private boolean groupNameSet;
    private boolean userIdSet;
    private boolean groupIdSet;
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;
    private boolean skipUnreadable = false;
    private String encoding = null;

    public TarFileSet() {
    }

    protected TarFileSet(FileSet fileset) {
        super(fileset);
    }

    protected TarFileSet(TarFileSet fileset) {
        super((ArchiveFileSet)fileset);
        this.encoding = fileset.encoding;
    }

    public void setEncoding(String enc) {
        this.checkTarFileSetAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        if (this.isReference()) {
            AbstractFileSet ref = this.getRef(this.getProject());
            if (ref instanceof TarFileSet) {
                return ((TarFileSet)ref).getEncoding();
            }
            return null;
        }
        return this.encoding;
    }

    public void setUserName(String userName) {
        this.checkTarFileSetAttributesAllowed();
        this.userNameSet = true;
        this.userName = userName;
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getUserName();
        }
        return this.userName;
    }

    public boolean hasUserNameBeenSet() {
        return this.userNameSet;
    }

    public void setUid(int uid) {
        this.checkTarFileSetAttributesAllowed();
        this.userIdSet = true;
        this.uid = uid;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getUid();
        }
        return this.uid;
    }

    public boolean hasUserIdBeenSet() {
        return this.userIdSet;
    }

    public void setGroup(String groupName) {
        this.checkTarFileSetAttributesAllowed();
        this.groupNameSet = true;
        this.groupName = groupName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getGroup();
        }
        return this.groupName;
    }

    public boolean hasGroupBeenSet() {
        return this.groupNameSet;
    }

    public void setGid(int gid) {
        this.checkTarFileSetAttributesAllowed();
        this.groupIdSet = true;
        this.gid = gid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getGid();
        }
        return this.gid;
    }

    public boolean hasGroupIdBeenSet() {
        return this.groupIdSet;
    }

    public void setSkipUnreadableEntries(boolean b) {
        this.skipUnreadable = b;
    }

    protected ArchiveScanner newArchiveScanner() {
        CommonsCompressArchiveScanner cs = new CommonsCompressArchiveScanner(new TarStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new TarResource(archive, encoding, (TarArchiveEntry)entry);
            }
        }, this.skipUnreadable, this.getProject());
        cs.setEncoding(this.encoding);
        return cs;
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.userNameSet || this.userIdSet || this.groupNameSet || this.groupIdSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected AbstractFileSet getRef(Project p) {
        this.dieOnCircularReference(p);
        Object o = this.getRefid().getReferencedObject(p);
        if (o instanceof TarFileSet) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            TarFileSet zfs = new TarFileSet((FileSet)o);
            this.configureFileSet(zfs);
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a tarfileset or a fileset";
        throw new BuildException(msg);
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        super.configureFileSet(zfs);
        if (zfs instanceof TarFileSet) {
            TarFileSet tfs = (TarFileSet)zfs;
            tfs.setUserName(this.userName);
            tfs.setGroup(this.groupName);
            tfs.setUid(this.uid);
            tfs.setGid(this.gid);
        }
    }

    public Object clone() {
        if (this.isReference()) {
            return ((TarFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkTarFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof TarFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

