/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.net.iharder.Base64;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONFormatter
implements Reporter,
Formatter {
    private final List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private final NiceAppendable out;
    private Map<String, Object> featureMap;
    private String uri;
    private List<Map> beforeHooks = new ArrayList<Map>();

    private Map getCurrentStep(Phase phase) {
        String target = phase.ordinal() <= Phase.match.ordinal() ? Phase.match.name() : Phase.result.name();
        Map lastWithValue = null;
        for (Map stepOrHook : this.getSteps()) {
            if (stepOrHook.get(target) == null) {
                return stepOrHook;
            }
            lastWithValue = stepOrHook;
        }
        return lastWithValue;
    }

    public JSONFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void uri(String uri) {
        this.uri = uri;
    }

    @Override
    public void feature(Feature feature) {
        this.featureMap = feature.toMap();
        this.featureMap.put("uri", this.uri);
        this.featureMaps.add(this.featureMap);
    }

    @Override
    public void background(Background background) {
        this.getFeatureElements().add(background.toMap());
    }

    @Override
    public void scenario(Scenario scenario) {
        this.getFeatureElements().add(scenario.toMap());
        if (this.beforeHooks.size() > 0) {
            this.getFeatureElement().put("before", this.beforeHooks);
            this.beforeHooks = new ArrayList<Map>();
        }
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.getFeatureElements().add(scenarioOutline.toMap());
    }

    @Override
    public void examples(Examples examples) {
        this.getAllExamples().add(examples.toMap());
    }

    @Override
    public void step(Step step) {
        this.getSteps().add(step.toMap());
    }

    @Override
    public void match(Match match) {
        this.getCurrentStep(Phase.match).put("match", match.toMap());
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
        HashMap<String, String> embedding = new HashMap<String, String>();
        embedding.put("mime_type", mimeType);
        embedding.put("data", Base64.encodeBytes(data));
        this.getEmbeddings().add(embedding);
    }

    @Override
    public void write(String text) {
        this.getOutput().add(text);
    }

    @Override
    public void result(Result result) {
        this.getCurrentStep(Phase.result).put("result", result.toMap());
    }

    @Override
    public void before(Match match, Result result) {
        this.beforeHooks.add(this.buildHookMap(match, result));
    }

    @Override
    public void after(Match match, Result result) {
        List<Map> hooks = this.getFeatureElement().get("after");
        if (hooks == null) {
            hooks = new ArrayList<Map>();
            this.getFeatureElement().put("after", hooks);
        }
        hooks.add(this.buildHookMap(match, result));
    }

    private Map buildHookMap(Match match, Result result) {
        HashMap<String, Map<String, Object>> hookMap = new HashMap<String, Map<String, Object>>();
        hookMap.put("match", match.toMap());
        hookMap.put("result", result.toMap());
        return hookMap;
    }

    public void appendDuration(int timestamp) {
        Map result = (Map)this.getCurrentStep(Phase.result).get("result");
        if (result != null) {
            long nanos = (long)timestamp * 1000000000L;
            result.put("duration", nanos);
        }
    }

    @Override
    public void eof() {
    }

    @Override
    public void done() {
        this.out.append(this.gson().toJson(this.featureMaps));
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    @Override
    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    private List<Map<String, Object>> getFeatureElements() {
        ArrayList featureElements = (ArrayList)this.featureMap.get("elements");
        if (featureElements == null) {
            featureElements = new ArrayList();
            this.featureMap.put("elements", featureElements);
        }
        return featureElements;
    }

    private Map<Object, List<Map>> getFeatureElement() {
        if (this.getFeatureElements().size() > 0) {
            return this.getFeatureElements().get(this.getFeatureElements().size() - 1);
        }
        return null;
    }

    private List<Map> getAllExamples() {
        List<Map> allExamples = this.getFeatureElement().get("examples");
        if (allExamples == null) {
            allExamples = new ArrayList<Map>();
            this.getFeatureElement().put("examples", allExamples);
        }
        return allExamples;
    }

    private List<Map> getSteps() {
        List<Map> steps = this.getFeatureElement().get("steps");
        if (steps == null) {
            steps = new ArrayList<Map>();
            this.getFeatureElement().put("steps", steps);
        }
        return steps;
    }

    private List<Map<String, String>> getEmbeddings() {
        ArrayList embeddings = (ArrayList)this.getCurrentStep(Phase.embedding).get("embeddings");
        if (embeddings == null) {
            embeddings = new ArrayList();
            this.getCurrentStep(Phase.embedding).put("embeddings", embeddings);
        }
        return embeddings;
    }

    private List<String> getOutput() {
        ArrayList output = (ArrayList)this.getCurrentStep(Phase.output).get("output");
        if (output == null) {
            output = new ArrayList();
            this.getCurrentStep(Phase.output).put("output", output);
        }
        return output;
    }

    protected Gson gson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    private static enum Phase {
        step,
        match,
        embedding,
        output,
        result;

    }
}

